<?php

namespace BuddyBossApp;
/**
 * Autoloads classes
 *
 */
class Autoloader {
	const PREFIX = 'BuddyBossAppScoping';

	/**
	 * Register the autoloader
	 */
	public static function register() {
		\spl_autoload_register( array( new self(), 'autoload' ) );
	}

	/**
	 * Autoloader
	 *
	 * @param string
	 */
	public static function autoload( $class ) {

		$plugin_include_path = dirname( __DIR__, 1 );
		$guzzle_functions    = "{$plugin_include_path}/Library/Composer/vendor/guzzlehttp/guzzle/src/functions_include.php";
		$promises_functions  = "{$plugin_include_path}/Library/Composer/vendor/guzzlehttp/promises/src/functions_include.php";
		$psr7_functions      = "{$plugin_include_path}/Library/Composer/vendor/guzzlehttp/psr7/src/functions_include.php";
		if ( file_exists( $guzzle_functions ) ) {
			require_once $guzzle_functions;
		}
		if ( file_exists( $promises_functions ) ) {
			require_once $promises_functions;
		}
		if ( file_exists( $psr7_functions ) ) {
			require_once $psr7_functions;
		}
		/**
		 * If IDNA_DEFAULT not set [google not connected]
		 */
		if ( ! \defined( 'IDNA_DEFAULT' ) ) {
			\define( 'IDNA_DEFAULT', 0 );
		}
	}
}

\BuddyBossApp\Autoloader::register();
