<?php
/**
 * Holds lesson meta rest api functionality.
 *
 * @package BuddyBossApp\ItemMeta
 */

namespace BuddyBossApp\ItemMeta;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * Lesson meta class.
 */
class LessonMeta extends ItemMeta {

	/**
	 * Class instance.
	 *
	 * @var null $instance
	 */
	private static $instance = null;

	/**
	 * LessonMeta constructor.
	 */
	private function __construct() {
		// ... leave empty, see Singleton below
	}

	/**
	 * Get the instance of this class.
	 *
	 * @return object
	 */
	public static function instance() {
		if ( null === self::$instance ) {
			$class_name                = __CLASS__;
			self::$instance            = new $class_name();
			self::$instance->post_type = 'sfwd-lessons';
			self::$instance->init();
		}

		return self::$instance;
	}

	/**
	 * Fires when Item(Lesson) is saved/updated
	 *
	 * @param \WP_REST_Response $response API response.
	 * @param \WP_Post          $post     Post data.
	 * @param bool              $update   Save or update.
	 *
	 * @return void
	 */
	public function on_save_or_update( $response, $post, $update ) {
		$item_type = $post->post_type;
		$meta_data = ItemMetaManager::prepare_meta( $post->ID );
		$status    = ItemMetaManager::update_or_insert_item( $post->ID, $item_type, $meta_data );

		if ( $status ) {
			// NOTE : Regenerating transient for this item.
			ItemMetaManager::set_transient_for_item( $post->ID );
		}
	}

	/**
	 * Retrieve/Get meta-information of item(Lesson) since specified timestamp
	 *
	 * @param string $item_type       Item type.
	 * @param array  $item_ids        Item ids.
	 * @param string $since_timestamp Time stamp.
	 *
	 * @return array
	 */
	public static function get_meta_by_item_ids( $item_type, $item_ids = null, $since_timestamp = null ) {
		$transient_key = bbapp()->transient_key;
		$metas         = array();

		foreach ( $item_ids as $item_id ) {
			$transient_name = $transient_key . $item_id . '-meta';

			if ( false === get_transient( $transient_name ) ) {
				$meta_data = ItemMetaManager::set_transient_for_item( $item_id );
			} else {
				$meta_data = get_transient( $transient_name );
			}

			if ( null === $since_timestamp ) {
				$metas[ $item_id ] = $meta_data;
			} else {
				if ( $meta_data['updates']['last_changed'] > $since_timestamp ) {
					$metas[ $item_id ] = $meta_data;
				}
			}
		}

		return $metas;
	}

	/**
	 * Fires on plugin activation.
	 */
	public function on_plugin_activate() {
		self::$instance->store_meta_once();
	}

	/**
	 * Fires on plugin deactivation.
	 */
	public function on_plugin_deactivate() {
	}

	/**
	 * Has lesson child.
	 *
	 * @return bool|void
	 */
	public function has_child() {
		// TODO: Implement has_child() method.
	}

	/**
	 * Has lesson parent.
	 *
	 * @return bool|void
	 */
	public function has_parent() {
		// TODO: Implement has_parent() method.
	}

}
