<?php

namespace BuddyBossApp\Integrations\IThemeSecurity;


/**
 * Contains all iTheme Security plugin related feature/issue fixes.
 *
 * Class Main
 *
 * @package BuddyBossApp\Integrations\IThemeSecurity
 */
class Main {
	/**
	 * Class instance.
	 *
	 * @var object
	 */
	private static $instance;

	/**
	 * Main constructor.
	 */
	public function __construct() {
	}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
			self::$instance->load(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 * load all security plugins related class.
	 */
	public function load() {
		add_action( 'rest_api_init', array( $this, 'remove_hook' ), 10 );
	}

	/**
	 * iTheme Security plugin issue.
	 */
	public function remove_hook() {
		if ( class_exists( 'ITSEC_WordPress_Tweaks' ) ) {
			remove_filter( 'rest_dispatch_request', array(
				\ITSEC_WordPress_Tweaks::get_instance(),
				'filter_rest_dispatch_request'
			), 10 );
		}
	}
}