<?php

namespace BuddyBossApp\Integrations\IMember360;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * Don't remove this code it's for reference for future to complete this integration.
 * Helper code
 *
 * global $SESSION, $i4w;
 *
 * iMember360()->authenticate( $user, $user->user_login, $SESSION['i4wuser']['Password'] )
 * iMember360()->user_cycles()
 * iMember360()->Contact_Soft_Sync()
 *
 *
 * i4w_load_xcontact( $contact_id, false );
 * var_dump( $i4w->CRecord );
 * $temp_session = $SESSION['i4wuser'];
 *
 * var_dump( $SESSION['i4wuser'] );
 *
 */

use BuddyBossApp\InAppPurchases\Controller;
use BuddyBossApp\InAppPurchases\IntegrationAbstract;
use BuddyBossApp\InAppPurchases\Orders;

// MemberPress Integration for BuddyBossApp InAppPurchases.
final class IAP extends IntegrationAbstract {

	private static $instance = null;

	private static $imember360 = null;

	/**
	 * MemberpressIntegration constructor.
	 */
	private function __construct() {
		// ... leave empty, see Singleton below
	}

	/**
	 * Get the instance of this class.
	 *
	 * @return Controller|null
	 */
	public static function instance() {
		if ( null === self::$instance ) {
			$className      = __CLASS__;
			self::$instance = new $className;
		}

		self::$imember360 = iMember360();

		return self::$instance;
	}

	/**
	 * Overriding the parent(from base-class) function
	 *
	 * @param $integration_type
	 * @param $integration_label
	 */
	public function set_up( $integration_type, $integration_label ) {

		$this->integration_slug = Controller::$imember360_slug;

		parent::set_up( $integration_type, $integration_label );

		$this->item_label = __( 'Membership', 'buddyboss-app' );

		// Register Instance
		bbapp_iap()->integration[ $integration_type ] = $this::instance();

		// NOTE : Customized actions
		add_action( 'save_bbapp_iap_product', array( $this, 'save_settings' ), 10, 2 );

	}

	/**
	 * Below function get triggers when(hook) order is completed.
	 *
	 * @param $item_ids
	 * @param $order
	 *
	 * @return mixed
	 */
	public function on_order_completed( $item_ids, $order ) {
		// Verify if memberpress plugin is active
		if ( ! function_exists( 'iMember360' ) ) {
			Orders::instance()->add_history( $order->id, 'iap-error', __( "Error while creating transaction as iMember360 plugin is not found.", 'buddyboss-app' ) );

			return false;
		}

		$contact_id = $this->get_infusionsoft_contact_id( $order->user_id );
		if ( ! empty( $contact_id ) ) {
			foreach ( $item_ids as $item_identifier ) {
				$split    = explode( ':', $item_identifier );
				$level_id = $split[0];

				self::$imember360->myApp->grpAssign( $contact_id, $level_id );
				self::$imember360->Contact_Soft_Sync();
				Orders::instance()->add_history( $order->id, 'info', __( "Assigned tag for user into infusion soft. Tag ID is #$level_id", 'buddyboss-app' ) );
			}
		} else {
			Orders::instance()->add_history( $order->id, 'info', __( "Contact not synced with Infusionsoft.", 'buddyboss-app' ) );
		}
	}

	/**
	 * Below function get triggers when(hook) order is activated.
	 *
	 * @param $item_ids
	 * @param $order
	 *
	 * @return mixed
	 */
	public function on_order_activate( $item_ids, $order ) {
		// NOTE : Similar to onOrderCompleted($order) until something needs to be changed?
		return $this->on_order_completed( $item_ids, $order );
	}

	/**
	 * Below function get triggers when(hook) order is cancelled.
	 *
	 * @param $item_ids
	 * @param $order
	 *
	 * @return mixed
	 */
	public function on_order_cancelled( $item_ids, $order ) {

		// Verify if memberpress plugin is active
		if ( ! function_exists( 'iMember360' ) ) {
			Orders::instance()->add_history( $order->id, 'iap-error', __( "Error while creating transaction as iMember360 plugin is not found.", 'buddyboss-app' ) );

			return false;
		}

		$contact_id = $this->get_infusionsoft_contact_id( $order->user_id );
		if ( ! empty( $contact_id ) ) {
			foreach ( $item_ids as $item_identifier ) {
				$split    = explode( ':', $item_identifier );
				$level_id = $split[0];
				self::$imember360->myApp->grpRemove( $contact_id, $level_id );

				//Only refresh data for current user. there is no way to refresh data for other user
				self::$imember360->Contact_Soft_Sync();
				Orders::instance()->add_history( $order->id, 'info', __( "Assigned tag for user into infusion soft. Tag ID is #$level_id", 'buddyboss-app' ) );
			}
		} else {
			Orders::instance()->add_history( $order->id, 'info', __( "Contact not synced with Infusionsoft.", 'buddyboss-app' ) );
		}
	}

	/**
	 * Below function get triggers when(hook) order is expired.
	 *
	 * @param $item_ids
	 * @param $order
	 *
	 * @return mixed
	 */
	public function on_order_expired( $item_ids, $order ) {
		// NOTE : Similar to onOrderCancelled($order) until something needs to be changed?
		$this->on_order_cancelled( $item_ids, $order );
	}

	function iap_linking_options( $results ) {
		$settings = self::$imember360->get_option('site_options', []);
		if ( ! empty( $settings['membership_levels'] ) ){
			$levels = $settings['membership_levels'];
			foreach ( $levels as $level_id => $level ) {
				$results[] = [
					'id'   => $level_id . ':' . $level['name'],
					'text' => $level['name'] . ':' . $level_id,
				];
			}
		}
		return $results;
	}

	function iap_integration_ids( $results, $integration_ids ) {
		$settings = self::$imember360->get_option('site_options', []);
		if ( ! empty( $settings['membership_levels'] ) ){
			$levels = $settings['membership_levels'];
			foreach ( $integration_ids as $key => $integration_id ) {
				$results[ $key ]['id']   = $integration_id;
				$results[ $key ]['text'] = "Not found: $integration_id";
				foreach ( $levels as $level_id => $level ) {
					/**
					 * Split[ level id, level name ];
					 */
					$split = explode( ':', $integration_id );
					if ( $level_id === (int) $split[0] ) {
						$results[ $key ]['text'] = $level['name'];
						break;
					}
				}
			}
		}
		return $results;
	}

	function item_id_permalink( $link, $item_id ) {
		return "admin.php?page=im360-memberships";
	}

	function is_purchase_available( $is_available, $item_id, $integration_item_id ) {
		//Not needed as plugin removing items from list if doesn't have access.
		return $is_available;
	}

	/**
	 * Check given integration item has access.
	 *
	 * @param $item_ids
	 * @param $user_id
	 *
	 * @return false
	 */
	function has_access( $item_ids, $user_id ) {
		if ( is_admin() ) {
			return true;
		}
		$has_access = false;

		$contact_id = $this->get_infusionsoft_contact_id( $user_id );
		if ( ! empty( $contact_id ) ) {
			foreach ( $item_ids as $item_identifier ) {
				$split    = explode( ':', $item_identifier );
				$level_id = $split[0];
				if ( i4w_has_tag( $level_id ) ) {
					$has_access = true;
				}
			}
		}
		return $has_access;
	}

	/**
	 * @param $user_id
	 *
	 * @return mixed
	 */
	public function sync_contact( $user_id ){
		global $SESSION;
		$user = get_userdata( $user_id );

		$contact_details = array(
			'Username'  => $user->user_login,
			'Email'     => $user->user_email,
			'FirstName' => $user->first_name,
			'LastName'  => $user->last_name,
			'Password'  => $SESSION['i4wuser']['Password'],
		);

		$contact_id = self::$imember360->myApp->addWithDupCheck($contact_details, $checkType = 'Email');
		if ( ! empty( $contact_id ) ) {
			update_user_meta($user_id,'infusion4wp_user_id',$contact_id );
			update_user_meta($user_id,'imember360_user_id',$contact_id );
			self::$imember360->Contact_Soft_Sync();
		}
		return $contact_id;
	}

	/**
	 * @param $user_id
	 *
	 * @return mixed
	 */
	private function get_infusionsoft_contact_id( $user_id ) {
		$infusionsoft_id = get_user_meta( $user_id, 'infusion4wp_user_id', true );
		if ( empty( $infusionsoft_id ) ) :
			$infusionsoft_id = get_user_meta( $user_id, 'imember360_user_id', true );
		endif;

		return $infusionsoft_id;
	}

	/**
	 * @param $tag_id
	 * @param $con_id
	 */
	private function i4w_has_tag( $tag_id, $contact_id ){
		$has_access = false;
		return $has_access;
	}
}