<?php
namespace BuddyBossApp\Integrations\IMember360;

// Contains all bbpress related feature
class Main {

	private static $instance;

	/**
	 * Main constructor.
	 */
	public function __construct() {}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if (!isset(self::$instance)) {
			$class = __CLASS__;
			self::$instance = new $class;
			self::$instance->load(); // run the hooks.
		}
		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {
		add_action( 'bbapp_auth_wp_login', array( $this, 'storeI4wSessionId'), 10, 3 );
		add_action( 'bbapp_auth_delete_jwt_token_request', array( $this, 'removeI4wSession') );
        add_action( 'init', array( $this, 'setI4wSession' ), 0 );
		add_action( 'init', array( $this, 'init') );
        LearnerRestAPI::instance();
    }

	/**
	 *
	 */
    public function setI4wSession(){
        if ( function_exists('iMember360') && is_user_logged_in() ) {
            $user_id = get_current_user_id();
	        $sessID = '';

	        $UserSessIDs = get_user_meta($user_id, '_bbapp_imember360', true);
	        if ( is_array( $UserSessIDs ) ){
		        $access_token = \BuddyBossApp\Auth\Common::instance()->get_access_token();
		        $auth_token_hash = hash( 'sha256', $access_token );
		        if ( isset( $UserSessIDs[ $auth_token_hash ] ) ) {
			        $sessID = $UserSessIDs[ $auth_token_hash ];
		        }
	        } else {
		        //Support for old Integration
		        $sessID = $UserSessIDs;
	        }

	        //For web cookie already set so no need to set again &&  For in app browser cookie already set so we need to update again.
	        if ( ! isset( $_COOKIE['imember360'] ) ||
	             ( isset( $_COOKIE['imember360'] )  && function_exists( 'bbapp_is_loaded_from_inapp_browser' ) && bbapp_is_loaded_from_inapp_browser() ) ||
	             ( !empty( $_GET['bbapp_learner_content'] ) || !empty( $_GET['bbapp_learner_video'] ) )
	        ){
		        $_COOKIE['imember360'] = $sessID;
	        }
        }
    }

	/**
	 *
	 */
    public function removeI4wSession( $request ){
        if ( function_exists('iMember360') && is_user_logged_in() ) {
            $user_id = get_current_user_id();

	        $UserSessIDs = get_user_meta($user_id, '_bbapp_imember360', true);
	        if ( is_array( $UserSessIDs ) ){
		        $access_token = \BuddyBossApp\Auth\Common::instance()->get_access_token();
		        $auth_token_hash = hash( 'sha256', $access_token );
		        if ( isset( $UserSessIDs[ $auth_token_hash ] ) ) {
		        	unset( $UserSessIDs[ $auth_token_hash ] );
		        }
	        } else {
	        	//Support for old Integration
		        $UserSessIDs = array();
	        }

	        update_user_meta( $user_id, '_bbapp_imember360' , $UserSessIDs );
        }
    }

	/**
	 *
	 */
    public function storeI4wSessionId( $user_login, $user, $data ) {
        global $i4w;
        IF (function_exists('iMember360') && is_user_logged_in()){
            $user_id = get_current_user_id();

	        $UserSessIDs = get_user_meta($user_id, '_bbapp_imember360', true);
            if ( empty( $UserSessIDs ) || ! is_array( $UserSessIDs ) ){
	            $UserSessIDs = array();
            }

            if ( ! empty( $data['token'] ) ){
	            $auth_token_hash = hash( 'sha256', $data['token'] );
	            $UserSessIDs[ $auth_token_hash ] = $i4w->sessID;
            }

            update_user_meta( $user_id, '_bbapp_imember360' , $UserSessIDs );
        }
    }

	/**
	 *
	 */
	public function init(){
		if ( function_exists('iMember360') ) {
			add_filter( "bbapp_menu_item_dependency",  array( $this, "imember360_filter_app_menu" ), 10, 2 );
		}
	}

	/**
	 * @param $status
	 * @param $menu
	 *
	 * @return array
	 */
	public function imember360_filter_app_menu( $status, $menu ) {

		global $i4w;
		if ( 'page' == $menu['object'] ) {
			$post_id = $menu['data']['id'];

			if ( (int) $post_id ) {
				$post = get_post( (int) $post_id );
			} else {
				$post = $menu['data']['id'];
			}

			if ( ! $i4w->match_user_content( $post, true ) ) {
				return false;
			}
		}

		return $status;
	}

}
