<?php
namespace BuddyBossApp\Integrations\IMember360;
class LearnerRestAPI {

    protected static $instance;

	/**
	 * LearnerRestAPI constructor.
	 */
    public function __construct() {
        /** Nothing here */
    }

	/**
	 * @return mixed
	 */
    public static function instance() {
        if (!isset(self::$instance)) {
            $class = __CLASS__;
            self::$instance = new $class;
            self::$instance->hooks(); // run the hooks.
        }
        return self::$instance;
    }

	/**
	 *
	 */
	public function hooks() {
        add_action('plugins_loaded', array($this, "load_rest"), 11);
	}

	/**
	 *
	 */
	public function load_rest(){
        if ( function_exists('iMember360') ) {
            add_filter('bbapp_ld_rest_prepare_course', array($this, 'courseRestrictRule'), 10, 3);
            add_filter('bbapp_ld_rest_prepare_lesson', array($this, 'lessonRestrictRule'), 10, 3);
            add_filter('bbapp_ld_rest_prepare_topic', array($this, 'topicRestrictRule'), 10, 3);
        }
    }

	/**
	 * @param $post
	 *
	 * @return bool
	 */
	private function check_access( $post ){
        global $i4w;
        $_post = get_post( $post->ID );
        return $i4w->match_user_content( $_post, TRUE ) && $i4w->learndash_match_user_content( $_post);
    }

    /**
     * Funcation: rule_content
     * @param $response
     * @param $post
     * @param $request
     * @return mixed
     */
    public function courseRestrictRule($response, $post, $request) {

        if ( $this->check_access( $post ) ){
            return $response;
        } else {
            $response->data['has_course_access'] = false;
            $response->data['has_content_access'] = false;
            // content is block by 3rd party so all purchasable option should be blocked.
            $response->data['purchasable'] = false;

            if (isset($response->data['hide_content_table'])) {
                $response->data['hide_content_table'] = true;
            }
            $response->data['error_message'] = array(
                'code' => 'learndash_json_imember360_course_access_invaild',
                'message' => '',
                'data' => array('status' => 400),

            );
        }

        return $response;
    }

    /**
     * Function: rule_content
     * @param $response
     * @param $post
     * @param $request
     * @return mixed
     */
    public function lessonRestrictRule($response, $post, $request) {

        if ( $this->check_access( $post ) ){
            return $response;
        } else {
            $response->data['has_course_access'] = false;
            $response->data['has_content_access'] = false;
            $response->data['error_message'] = array(
                'code' => 'learndash_json_imember360_lesson_access_invaild',
                'message' => '',
                'data' => array('status' => 400),

            );
        }
        return $response;
    }

    /**
     * Funcation: rule_content
     * @param $response
     * @param $post
     * @param $request
     * @return mixed
     */
    public function topicRestrictRule($response, $post, $request) {
        if ( $this->check_access( $post ) ){
            return $response;
        } else {
            $response->data['has_course_access'] = false;
            $response->data['has_content_access'] = false;
            $response->data['error_message'] = array(
                'code' => 'learndash_json_imember360_topic_access_invaild',
                'message' => '',
                'data' => array('status' => 400),

            );
        }
        return $response;
    }

}