<?php

namespace BuddyBossApp\Integrations\Wordfence;

/**
 * Contains all Wordfence plugin related features/hooks/filters
 *
 * Class Main
 *
 * @package BuddyBossApp\Integrations\Wordfence
 */
class Main {

	private static $instance;

	/**
	 * Main constructor.
	 */
	public function __construct() {
	}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
			self::$instance->load(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {
		add_action( 'rest_api_init', array( $this, 'remove_hook' ), 10 );
	}

	/**
	 * Wordfence plugin (2FA support).
	 */
	public function remove_hook() {
		define('WORDFENCE_LS_AUTHENTICATION_CHECK',true);
		// Remove recaptcha authentication hook.
		if ( class_exists( 'WordfenceLS\\Controller_WordfenceLS' ) ) {
			$wordfencels_obj = new \WordfenceLS\Controller_WordfenceLS();
			remove_filter( 'authenticate', array( $wordfencels_obj::shared(), '_authenticate' ), 25, 3 );
		}
	}

}