<?php

namespace BuddyBossApp\Integrations\WishlistMember;

use BuddyBossApp\UserSegment\SegmentsAbstract as SegmentsAbstract;

class Segment extends SegmentsAbstract {

	/**
	 * Learndash constructor.
	 */
	public function __construct() {

		$this->add_filter( "membership", "user_wishlist_level", array( "wishlist_level_select" ) );

		// MemberPress Level
		$options  = array();
		$products = class_exists( '\WishListMember_Level' ) ? \WishListMember_Level::GetAllLevels( true ) : \WishListMember\Level::GetAllLevels( true );
		foreach ( $products as $product ) {
			$options[ $product->ID ] = $product->name;
		}
		$this->add_field( "wishlist_level_select", "Checkbox", array(
			"options"       => $options,
			"multiple"      => true,
			"title"         => __( "If the member has any of these memberships", "buddyboss-app" ),
			"empty_message" => __( "No memberships found.", "buddyboss-app" ),
		) );

		$this->load();
	}

	/**
	 * @param $r_users_ids
	 *
	 * @return array
	 */
	public function filter_users( $r_users_ids ): array {

		$filter    = $this->get_filter_data_value( 'filter' );
		$users_ids = array();

		switch ( $filter ) {
			case 'membership_user_wishlist_level':
				$product_ids = (array) $this->get_filter_data_value( 'wishlist_level_select' );

				foreach ( $product_ids as $product_id ) {
					$response = wlmapi_get_level_members( $product_id );
					if ( $response['success'] && ! empty( $response['members'] ) && ! empty( $response['members']['member'] ) ) {
						$_users_ids = array_column( $response['members']['member'], 'id' );
						$users_ids  = array_merge( $users_ids, $_users_ids );
					}
				}

				$users_ids = array_unique( $users_ids );
				break;
		}

		if ( ! empty( $users_ids ) ) {
			return $users_ids;
		}

		return $r_users_ids;
	}

	/**
	 * Render script
	 */
	function render_script() {
		// TODO: Implement render_script() method.
	}
}
