<?php

namespace BuddyBossApp\Integrations\WishlistMember;

class Main {

	private static $instance;

	/**
	 * MemberPress constructor.
	 */
	public function __construct() {
		//Using Singleton, see instance()
	}

	/**
	 * @return Main
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
			self::$instance->load(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {
		add_action( 'init', array( $this, "hook" ) );
	}

	/**
	 *
	 */
	public function hook() {
		if ( class_exists( '\WishListMember' ) ) {
			add_action( 'rest_api_init', array( $this, "rest_hook" ) );
			add_filter( 'bbapp_user_segment_integrations', array( $this, 'load_segment' ), 11 );
		}
	}

	/**
	 * Filter for rest api.
	 */
	public function rest_hook() {
		// Restrict content for rest
	}

	/**
	 * Load Learndash related user segments
	 *
	 * @param $integrations
	 *
	 * @return mixed
	 */
	public function load_segment( $integrations ) {
		$integrations['wishlist_membership'] = new Segment();

		return $integrations;
	}
}
