<?php

namespace BuddyBossApp\Integrations\WcMembership;

class Main {

	private static $instance;

	/**
	 * MemberPress constructor.
	 */
	public function __construct() {
		//Using Singleton, see instance()
	}

	/**
	 * @return Main
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
			self::$instance->load(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {
		add_action( 'init', array( $this, "hook" ) );
	}

	/**
	 *
	 */
	public function hook() {
		if ( class_exists( 'WC_Memberships' ) ) {
			add_action( 'rest_api_init', array( $this, "rest_hook" ) );
			add_filter( 'bbapp_user_segment_integrations', array( $this, 'load_segment' ), 11 );
		}
	}

	/**
	 * Filter for rest api.
	 */
	public function rest_hook() {
		add_filter( 'bbapp_ld_rest_prepare_course', array( $this, 'course_restrict_memberpress_rule' ), 10, 3 );
		add_filter( 'bbapp_ld_rest_prepare_lesson', array( $this, 'lesson_restrict_memberpress_rule' ), 10, 3 );
		add_filter( 'bbapp_ld_rest_prepare_topic', array( $this, 'topic_restrict_memberpress_rule' ), 10, 3 );
	}

	/**
	 * Load Learndash related user segments
	 *
	 * @param $integrations
	 *
	 * @return mixed
	 */
	public function load_segment( $integrations ) {
		$integrations['wc_membership'] = new Segment();

		return $integrations;
	}

	/**
	 * memberpress/app/controllers/MeprRulesCtrl.php
	 * Funcation: rule_content
	 *
	 * @param $response
	 * @param $post
	 * @param $request
	 *
	 * @return mixed
	 */
	public function course_restrict_memberpress_rule( $response, $post, $request ) {
		if ( ! function_exists( 'wc_memberships_is_post_content_restricted' ) ) {
			return $response;
		}

		if ( ! wc_memberships_is_post_content_restricted( $post->ID ) ) {
			return $response;
		}

		if ( ! current_user_can( 'wc_memberships_view_restricted_post_content', $post->ID ) ) {
			$response->data['has_course_access']  = false;
			$response->data['has_content_access'] = false;
			// content is block by 3rd party so all purchasable option should be blocked.
			$response->data['purchasable'] = false;

			if ( isset( $response->data['hide_content_table'] ) ) {
				$response->data['hide_content_table'] = true;
			}
			$response->data['error_message'] = array(
				'code'    => 'learndash_json_wc_memberships_course_access_invaild',
				'message' => '',
				'data'    => array( 'status' => 400 ),

			);
		}

		return $response;
	}

	/**
	 * memberpress/app/controllers/MeprRulesCtrl.php
	 * Funcation: rule_content
	 *
	 * @param $response
	 * @param $post
	 * @param $request
	 *
	 * @return mixed
	 */
	public function lesson_restrict_memberpress_rule( $response, $post, $request ) {

		$uri = $_SERVER['REQUEST_URI'];
		if ( ! function_exists( 'wc_memberships_is_post_content_restricted' ) ) {
			return $response;
		}

		if ( ! wc_memberships_is_post_content_restricted( $post->ID ) ) {
			return $response;
		}

		//Check course access
		$course_id = bbapp_learndash_get_course_id( $post->ID );
		$course    = get_post( $course_id );
		$response  = $this->course_restrict_memberpress_rule( $response, $course, $uri );

		if ( ! current_user_can( 'wc_memberships_view_restricted_post_content', $post->ID ) ) {
			$response->data['has_course_access']  = false;
			$response->data['has_content_access'] = false;
			$response->data['error_message']      = array(
				'code'    => 'learndash_json_wc_memberships_lesson_access_invaild',
				'message' => '',
				'data'    => array( 'status' => 400 ),

			);
		}

		return $response;
	}

	/**
	 * memberpress/app/controllers/MeprRulesCtrl.php
	 * Funcation: rule_content
	 *
	 * @param $response
	 * @param $post
	 * @param $request
	 *
	 * @return mixed
	 */
	public function topic_restrict_memberpress_rule( $response, $post, $request ) {
		$uri = $_SERVER['REQUEST_URI'];
		if ( ! function_exists( 'wc_memberships_is_post_content_restricted' ) ) {
			return $response;
		}

		if ( ! wc_memberships_is_post_content_restricted( $post->ID ) ) {
			return $response;
		}

		//Check course/lesson access
		$lesson_id = bbapp_learndash_get_lesson_id( $post->ID );
		$lesson    = get_post( $lesson_id );
		$response  = $this->course_restrict_memberpress_rule( $response, $lesson, $uri );

		if ( ! current_user_can( 'wc_memberships_view_restricted_post_content', $post->ID ) ) {
			$response->data['has_course_access']  = false;
			$response->data['has_content_access'] = false;
			$response->data['error_message']      = array(
				'code'    => 'learndash_json_wc_memberships_topic_access_invalid',
				'message' => '',
				'data'    => array( 'status' => 400 ),

			);
		}

		return $response;
	}
}
