<?php

namespace BuddyBossApp\Integrations\WcMembership;

use BuddyBossApp\UserSegment\SegmentsAbstract as SegmentsAbstract;

class Segment extends SegmentsAbstract {

	/**
	 * Learndash constructor.
	 */
	public function __construct() {

		$this->add_filter( "membership", "user_wc_level", array( "wc_level_select" ) );

		// MemberPress Level
		$options  = array();
		$products = wc_memberships_get_membership_plans();
		foreach ( $products as $product ) {
			$options[ $product->id ] = $product->name;
		}
		$this->add_field( "wc_level_select", "Checkbox", array(
			"options"       => $options,
			"multiple"      => true,
			"title"         => __( "If the member has any of these memberships", "buddyboss-app" ),
			"empty_message" => __( "No memberships found.", "buddyboss-app" ),
		) );

		$this->load();
	}

	/**
	 * @param $r_users_ids
	 *
	 * @return array
	 */
	public function filter_users( $r_users_ids ): array {
		$filter    = $this->get_filter_data_value( 'filter' );
		$users_ids = array();

		switch ( $filter ) {
			case 'membership_user_wc_level':
				$product_ids = (array) $this->get_filter_data_value( 'wc_level_select' );

				foreach ( $product_ids as $product_id ) {
					$membership_plan = wc_memberships_get_membership_plan( $product_id );

					if ( $membership_plan instanceof \WC_Memberships_Membership_Plan ) {
						$memberships = $membership_plan->get_memberships( array(
							'post_status' => array( 'wcm-active' ),
						) );

						if ( ! empty( $memberships ) ) {
							$_users_ids = wp_list_pluck( $memberships, 'user_id' );
							$users_ids  = array_merge( $users_ids, $_users_ids );

						}
					}
				}

				$users_ids = array_unique( $users_ids );
				break;
		}

		if ( ! empty( $users_ids ) ) {
			return $users_ids;
		}

		return $r_users_ids;
	}

	/**
	 * Render script
	 */
	function render_script() {
		// TODO: Implement render_script() method.
	}
}
