<html>

<head>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>
<?php
$color = '#000';
if ( ! empty( $_GET['color'] ) ) {
	$color = $_GET['color'];
}
?>
<body style="background-color: <?php echo esc_attr( $color ); ?>; margin: 0;">
<div id="player"></div>
<script src="https://player.vimeo.com/api/player.js"></script>
<script>
	/**
	 * Function to be called by App.
	 *
	 * @param {string}  vid        - Video ID.
	 * @param {number}  width      - Video width.
	 * @param {number}  height     - Video height.
	 * @param {string}  OS         - Operating System.
	 * @param {boolean} responsive - Responsive.
	 * @param {string}  bgColor    - Background color.
	 * @param {boolean} autoplay   - Autoplay.
	 * @param {boolean} controls   - Controls.
	 */
	function bbapp_load_vimeo( vid, width, height, OS, responsive, bgColor, autoplay, controls ) {
		//Change body color according to app theme.
		document.body.style.background = bgColor;

		const responsiveStyle = ( responsive ) && {
			responsive: true,
			width: '100%',
			height: '100%',
		};

		const heightOffset = 20;

		const isPrivate = vid.includes( '/' );
		const id = ( isPrivate ) ? 'https://vimeo.com/' + vid : vid;

		const options = {
			id,
			url: 'https://vimeo.com/' + vid,
			playsinline: true,
			width,
			controls,
			autoplay,
			height: ( height ) && height - heightOffset, //To center vimeo video
			...responsiveStyle,
		};

		// eslint-disable-next-line no-undef
		this.player = new Vimeo.Player( 'player', options );

		this.player.on( 'play', function() {
			return sendMessageToRN( 'PLAYING' );
		} );

		/**
		 * Workaround to "END" a video
		 */
		this.player.on( 'timeupdate', function( data ) {
			if ( data.percent === 1 || data.percent === '1' ) {
				return sendMessageToRN( 'ENDED' );
			}
		} );

		/**
		 * Workaround to avoid video lagging in android.
		 */
		this.player.getDuration().then( async function( duration ) {
			sendMessageToRN( 'LOADED' );
			if ( OS === 'android' ) {
				// duration = the duration of the video in seconds
				if ( await this.player.getVideoWidth() >= 1920 && await this.player.getVideoHeight() >= 1080 && (
					duration / 60
				) > 5 ) {
					await this.player.setQuality( '240p' );
				}
			}
		} ).catch( function( error ) {
			// eslint-disable-next-line no-console
			console.log( error );
		} );

		/**
		 * If pause event is added on the player,
		 * stopped, ended and finish are not being called in webview but works in browser
		 */
		this.player.on( 'stopped', function() {
			return sendMessageToRN( 'STOPPED' );
		} );

		this.player.on( 'ended', function() {
			return sendMessageToRN( 'ENDED' );
		} );

		this.player.on( 'pause', function() {
			return sendMessageToRN( 'PAUSED' );
		} );

		/**
		 * Function to send message to RN.
		 *
		 * @param {string} message - Message to be sent to RN.
		 */
		function sendMessageToRN( message ) {
			if ( OS === 'ios' ) {
				if ( window.ReactNativeWebView.postMessage.length !== 1 ) {
					setTimeout( sendMessageToRN( message ), 200 );
				} else {
					window.ReactNativeWebView.postMessage( message );
				}
			} else {
				window.ReactNativeWebView.postMessage( message );
				setTimeout( () => window.ReactNativeWebView.postMessage( message ), 50 );
			}
		}
	}
</script>
</body>

</html>
