<?php

namespace BuddyBossApp\Integrations\Vimeo;

/**
 * Class VimeoEmbed
 *
 * @package BuddyBossApp\Integrations\Vimeo
 */
class VimeoEmbed {

	/**
	 * Class instance.
	 *
	 * @var object
	 */
	private static $instance;

	/**
	 * VimeoEmbed constructor.
	 */
	public function __construct() {
	}

	/**
	 * Class instance called.
	 *
	 * @return mixed
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 * Load hooks function on instance.
	 */
	public function load() {
		$this->hooks();
	}

	/**
	 * Adding hooks.
	 */
	public function hooks() {
		add_action( 'plugins_loaded', array( $this, 'load_vimeo_embed' ), 1 );
	}

	/**
	 * Register Vimeo Embed Support.
	 */
	public function load_vimeo_embed() {
		if ( isset( $_GET['bbapp-vimeo-embed'] ) && ! empty( $_GET['bbapp-vimeo-embed'] ) ) {
			$this->get_vimeo_embed_page();
			exit;
		}
	}

	/**
	 * Render the Vimeo Embed HTML.
	 */
	public function get_vimeo_embed_page() {
		require bbapp()->plugin_dir . 'include/Integrations/Vimeo/vimeo-embed-html.php';
	}

}
