<?php

namespace BuddyBossApp\Integrations\VerifiedMemberForBuddypress;
// Contains all VerifiedMemberForBuddypress related feature
class Main {

    private static $instance;

    /**
     * Main constructor.
     */
    public function __construct() {
    }

    /**
     * @return mixed
     */
    public static function instance() {
        if ( ! isset( self::$instance ) ) {
            $class          = __CLASS__;
            self::$instance = new $class;
            self::$instance->load(); // run the hooks.
        }

        return self::$instance;
    }

	/**
	 * Load the integration hooks
	 *
	 * @since 1.5.2.1
	 * @return void
	 */
	public function load() {
		if ( defined( 'BP_VERIFIED_MEMBER_VERSION' ) ) {
			add_filter( 'bp_after_notifications_add_notification_parse_args', array(
				$this,
				'modify_verified_member_notification_args'
			) );
		}
	}

	/**
	 * Modify verified member's notification args
	 *
	 * @param array $r Notification args
	 *
	 * @since 1.5.2.1
	 * @return  array $r Notification args
	 */
	function modify_verified_member_notification_args( $r ) {
		if (
			isset( $r['component_name'] ) &&
			isset( $r['item_id'] ) &&
			$r['component_name'] === 'bp_verified_member' &&
			$r['item_id'] === 0
		) {
			$r['item_id'] = $r['user_id'];
		}

		return $r;
	}

}
