<?php
/**
 * Holds functionality related to show the list of TutorLMS courses.
 *
 * @package BuddyBossApp\Integrations\TutorLMS\AccessControls
 */

namespace BuddyBossApp\Integrations\TutorLMS\AccessControls;

use BuddyBossApp\AccessControls\Core\List_Table;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * Course custom list.
 */
class TutorLMSCourseList extends List_Table {

	/**
	 * Class constructor
	 *
	 * @since 2.2.80
	 */
	public function __construct() {

		parent::__construct(
			TutorLMSCourse::instance()->post_type,
			array(
				'singular'     => __( 'Course', 'buddyboss-app' ), // singular name of the listed records.
				'plural'       => __( 'Courses', 'buddyboss-app' ), // plural name of the listed records.
				'ajax'         => false, // should this table support ajax?
				'screen'       => TutorLMSCourse::instance()->screen_name,
				'column_slug'  => 'course',
				'column_title' => __( 'Course', 'buddyboss-app' ),

			)
		);
	}

	/**
	 * No course found
	 *
	 * @since 2.2.80
	 */
	public function no_items() {
		esc_html_e( 'No access course found.', 'buddyboss-app' );
	}

	/**
	 * Course column custom values.
	 *
	 * @param object $item Course item.
	 *
	 * @since 2.2.80
	 *
	 * @return void
	 */
	public function column_course( $item ) {
		$output = '';
		$title  = $item->post_title;

		if ( empty( $title ) ) {
			$title = esc_html__( '(no title)', 'buddyboss-app' );
		}

		if ( current_user_can( 'edit_posts', $item->ID ) ) {
			$output .= '<strong><a href="' . get_edit_post_link( $item->ID ) . '">' . apply_filters( 'the_title', $title, $item->ID ) . '</a></strong>';
		} else {
			$output .= '<strong>' . apply_filters( 'the_title', $title, $item->ID ) . '</strong>';
		}

		echo wp_kses_post( $output );
	}

	/**
	 * Checkbox for bulk items.
	 *
	 * @param object $item Access rule item.
	 *
	 * @since 2.2.80
	 *
	 * @return void
	 */
	public function column_inherited_from( $item ) {
		$inherited_from = TutorLMSCourse::instance()->get_access_inherited_from( $item->ID, $item->post_type );

		if ( 'item' === $inherited_from['type'] ) {
			echo '-';
		} elseif ( 'taxonomy' === $inherited_from['type'] ) {
			$stored_term = $inherited_from['term'];
			printf( '%s: <a href="%s">%s</a>', esc_html( get_taxonomy( $stored_term->taxonomy )->labels->singular_name ), esc_url( get_term_link( $stored_term, $stored_term->taxonomy ) ), esc_html( $stored_term->name ) );
		} else {
			echo esc_html_x( 'Default Settings', 'access controls integration course list', 'buddyboss-app' );
		}
	}
}
