<?php

namespace BuddyBossApp\Integrations\SimpleGooglereCaptcha;

/**
 * Contains all Simple Google reCaptcha plugin related features/hooks/filters
 *
 * Class Main
 *
 * @package BuddyBossApp\Integrations\SimpleGooglereCaptcha
 */
class Main {

	private static $instance;

	/**
	 * Main constructor.
	 */
	public function __construct() {
	}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {
		add_action( 'rest_api_init', array( $this, 'remove_hook' ), 10 );
	}

	/**
	 * Simple Google reCaptcha plugin support.
	 */
	public function remove_hook() {
		$sgr_verify_list = array(
			'lostpassword_post',
			'wp_authenticate_user',
		);

		foreach ( $sgr_verify_list as $sgr_verify ) {
			$this->force_remove_filter( $sgr_verify, '\SimpleGoogleRecaptcha', 'verify' );
		}
	}

	/**
	 * Forcefully remove filter.
	 *
	 * @param string $tag         The name of the filter to remove.
	 * @param string $class_name  The class name of the filter to remove.
	 * @param string $method_name The method name of the filter to remove.
	 */
	public function force_remove_filter( $tag, $class_name, $method_name ) {
		$filters = isset( $GLOBALS['wp_filter'][ $tag ] ) ? $GLOBALS['wp_filter'][ $tag ] : 0;
		if ( empty( $filters ) ) {
			return;
		}
		foreach ( $filters as $priority => $filter ) {
			foreach ( $filter as $identifier => $function ) {
				if (
					is_array( $function ) &&
					is_array( $function['function'] ) &&
					is_a( $function['function'][0], $class_name ) &&
					$method_name === $function['function'][1]
				) {
					remove_filter( $tag, array( $function['function'][0], $method_name ), $priority );
				}
			}
		}
	}
}
