<?php

namespace BuddyBossApp\Integrations\S2Member;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

use BuddyBossApp\InAppPurchases\Controller;
use BuddyBossApp\InAppPurchases\IntegrationAbstract;
use BuddyBossApp\InAppPurchases\Orders;

//Woo Membership Integration for InAppPurchases.
final class IAP extends IntegrationAbstract {

	private static $instance = null;

	private function __construct() {
		// ... leave empty, see Singleton below
	}

	/**
	 * Get the instance of this class.
	 *
	 * @return IAP|null
	 */
	public static function instance() {
		if ( null === self::$instance ) {
			$className      = __CLASS__;
			self::$instance = new $className;
		}

		return self::$instance;
	}

	/**
	 * Overriding the parent(from base-class) function
	 *
	 * @param $integration_type
	 * @param $integration_label
	 */
	public function set_up( $integration_type, $integration_label ) {

		$this->integration_slug = Controller::$s2member_slug;

		parent::set_up( $integration_type, $integration_label );

		$this->item_label = __( 'Membership', 'buddyboss-app' );

		// Register Instance
		bbapp_iap()->integration[ $integration_type ] = $this::instance();
	}

	/**
	 * Trigger following code when BuddyBoss App order completed
	 *
	 * @param $item_ids
	 * @param $order
	 *
	 * @return false|mixed
	 */
	public function on_order_completed( $item_ids, $order ) {

		if ( ! defined( 'WS_PLUGIN__S2MEMBER_VERSION' ) ) {
			Orders::instance()->add_history( $order["id"], 'iap-error',__( "s2Member plugin is not activated.", "buddyboss-app" ) );

			return false;
		}

		$user = new \WP_User ( $order->user_id );

		foreach ( $item_ids as $item_identifier ) {
			$split    = explode( ':', $item_identifier );
			$level_id = $split[0];

			$current_role = \c_ws_plugin__s2member_user_access::user_access_role( $user );
			if ( $current_role !== 's2member_level' . $level_id ) {
				$user->set_role( 's2member_level' . $level_id );
			}

			$user->add_cap( 'access_s2member_ccap_' . $level_id );
		}
	}

	/**
	 * Trigger following code when BuddyBoss App order Activated
	 *
	 * @param $item_ids
	 * @param $order
	 *
	 * @return false|mixed
	 */
	public function on_order_activate( $item_ids, $order ) {
		return $this->on_order_completed( $item_ids, $order );
	}

	/**
	 * Trigger following code when BuddyBoss App order cancelled
	 *
	 * @param $item_ids
	 * @param $order
	 *
	 * @return false
	 */
	public function on_order_cancelled( $item_ids, $order ) {

		if ( ! defined( 'WS_PLUGIN__S2MEMBER_VERSION' ) ) {
			Orders::instance()->add_history( $order["id"], 'iap-error', __( "s2Member plugin is not activated.", "buddyboss-app" ) );

			return false;
		}

		$user = new \WP_User ( $order->user_id );

		foreach ( $item_ids as $item_identifier ) {
			$split    = explode( ':', $item_identifier );
			$level_id = $split[0];

			$current_role = \c_ws_plugin__s2member_user_access::user_access_role( $user );
			if ( $current_role === 's2member_level' . $level_id ) {
				$user->remove_role( 's2member_level' . $level_id );
			}

			$user->remove_cap( 'access_s2member_ccap_' . $level_id );
		}
	}

	/**
	 * Trigger following code when BuddyBoss App order expired
	 *
	 * @param $item_ids
	 * @param $order
	 */
	public function on_order_expired( $item_ids, $order ) {
		$this->on_order_cancelled( $item_ids, $order );
	}

	/**
	 * Handle bbapp ajax iap_linking_options for this integration
	 *
	 * @param $results levels data
	 * @param $search : Search term
	 *
	 * @return mixed
	 */
	public function iap_linking_options( $results ) {
		$levels = $this->get_membership();
		foreach ( $levels as $level ) {
			$results[] = [
				'id'   => $level['id'] . ':' . $level['name'],
				'text' => $level['name'] . ':' . $level['id'],
			];
		}

		return $results;
	}

	/**
	 * Handle bbapp ajax iap_integration_ids for this integration
	 * it's return items label with id.
	 *
	 * @param $results levels data
	 * @param $integration_ids selected integration id
	 *
	 * @return mixed
	 */
	public function iap_integration_ids( $results, $integration_ids ) {
		$levels = $this->get_membership();
		foreach ( $integration_ids as $key => $integration_id ) {
			$results[ $key ]['id']   = $integration_id;
			$results[ $key ]['text'] = "Not found: $integration_id";

			foreach ( $levels as $level ) {
				/**
				 * Split[ level id, level name ];
				 */
				$split = explode( ':', $integration_id );
				if ( $level['id'] === (int) $split[0] ) {
					$results[ $key ]['text'] = $level['name'];
					break;
				}
			}
		}

		return $results;
	}

	/**
	 * Get item edit link to show on order page.
	 *
	 * @param $link
	 * @param $item_id
	 *
	 * @return string
	 */
	public function item_id_permalink( $link, $item_id ) {
		return 'admin.php?page=ws-plugin--s2member-gen-ops';
	}

	/**
	 * Check given post has given membership configured or not
	 *
	 * @param $has_access
	 * @param $forItemId
	 * @param $integration_item_id
	 *
	 * @return bool
	 */
	public function is_purchase_available( $has_access, $forItemId, $integration_item_id ) {
		//Not needed as plugin removing items from list if doesn't have access.
		return $has_access;
	}

	/**
	 * Check given integration item has access.
	 *
	 * @param $item_ids
	 * @param $user_id
	 *
	 * @return false
	 */
	function has_access( $item_ids, $user_id ) {
		if ( is_admin() ) {
			return true;
		}
		$has_access = false;

		foreach ( $item_ids as $item_identifier ) {
			$split    = explode( ':', $item_identifier );
			$level_id = $split[0];

			if ( user_is( 's2member_level' . $level_id ) ){
				$has_access = true;
				break;
			}
		}

		return $has_access;
	}

	private function get_membership() {
		$levels = [];
		if ( ! empty( $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"] ) ) {
			for ( $n = 0; $n <= $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]; $n ++ ) {
				$levels[] = array(
					'id'   => $n,
					'name' => $GLOBALS["WS_PLUGIN__"]["s2member"]["o"][ "level" . $n . "_label" ],
				);
			}
		}

		return $levels;
	}
}
