<?php

namespace BuddyBossApp\Integrations\S2Member;

use BuddyBossApp\UserSegment\SegmentsAbstract as SegmentsAbstract;

class Segment extends SegmentsAbstract {

	/**
	 * Learndash constructor.
	 */
	public function __construct() {

		$this->add_filter( "membership", "user_s2member_level", array( "s2member_level_select" ) );

		// MemberPress Level
		$options  = array();
		$products = $this->get_membership();
		foreach ( $products as $product ) {
			$options[ $product['id'] ] = $product['name'];
		}
		$this->add_field( "s2member_level_select", "Checkbox", array(
			"options"       => $options,
			"multiple"      => true,
			"title"         => __( "If the member has any of these memberships", "buddyboss-app" ),
			"empty_message" => __( "No memberships found.", "buddyboss-app" ),
		) );

		$this->load();
	}

	/**
	 * @param $r_users_ids
	 *
	 * @return array
	 */
	public function filter_users( $r_users_ids ): array {
		$filter    = $this->get_filter_data_value( 'filter' );
		$users_ids = array();

		switch ( $filter ) {
			case 'membership_user_s2member_level':
				$product_ids = (array) $this->get_filter_data_value( 's2member_level_select' );

				foreach ( $product_ids as $product_id ) {
					$product_id = ( (int) $product_id ) === 0 ? 'subscriber' : 's2member_level' . $product_id;
					$_users_ids = get_users( array(
						'fields'   => 'ids',
						'role__in' => array( $product_id )
					) );
					$users_ids  = array_merge( $users_ids, $_users_ids );
				}

				$users_ids = array_unique( $users_ids );
				break;
		}

		if ( ! empty( $users_ids ) ) {
			return $users_ids;
		}

		return $r_users_ids;
	}

	/**
	 * Render script
	 */
	function render_script() {
		// TODO: Implement render_script() method.
	}

	/**
	 * Get membership list
	 * @return array
	 */
	private function get_membership() {
		$levels = [];
		if ( ! empty( $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"] ) ) {
			for ( $n = 0; $n <= $GLOBALS["WS_PLUGIN__"]["s2member"]["c"]["levels"]; $n ++ ) {
				$levels[] = array(
					'id'   => $n,
					'name' => $GLOBALS["WS_PLUGIN__"]["s2member"]["o"][ "level" . $n . "_label" ],
				);
			}
		}

		return $levels;
	}
}
