<?php

namespace BuddyBossApp\Integrations\S2Member;

// All s2member related chages

class Main {

	private static $instance;

	/**
	 * Main constructor.
	 */
	public function __construct() {
	}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
			self::$instance->load(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {
		add_action( 'init', array( $this, 'init' ) );
	}

	/**
	 *
	 */
	public function init() {
		if ( defined( 'WS_PLUGIN__S2MEMBER_VERSION' ) ) {
			add_action( 'rest_api_init', array( $this, "rest_hook" ) );
			add_filter( 'bbapp_user_segment_integrations', array( $this, 'load_segment' ), 11 );
		}
	}

	/**
	 * Filter for rest api.
	 */
	public function rest_hook() {
		add_filter( "bbapp_menu_item_dependency", array( $this, "s2member_filter_app_menu" ), 10, 2 );
	}

	/**
	 * Load Learndash related user segments
	 *
	 * @param $integrations
	 *
	 * @return mixed
	 */
	public function load_segment( $integrations ) {
		$integrations['s2member_membership'] = new Segment();

		return $integrations;
	}

	/**
	 * @param $status
	 * @param $menu
	 *
	 * @return array
	 */
	function s2member_filter_app_menu( $status, $menu ) {
		if ( 'page' == $menu['object'] && function_exists( 'is_page_permitted_by_s2member' ) ) {
			$is_protected = is_page_permitted_by_s2member( $menu['data']['id'] );
			if ( ! $is_protected ) {
				return false;
			}
		}

		return $status;
	}
}