<?php

namespace BuddyBossApp\Integrations\RestrictContentPro;

use BuddyBossApp\UserSegment\SegmentsAbstract as SegmentsAbstract;

class Segment extends SegmentsAbstract {

	/**
	 * Learndash constructor.
	 */
	public function __construct() {

		$this->add_filter( "membership", "user_rcpro_level", array( "repro_level_select" ) );

		// MemberPress Level
		$options  = array();
		$products = rcp_get_subscription_levels();
		foreach ( $products as $product ) {
			$options[ $product->id ] = $product->name;
		}
		$this->add_field( "repro_level_select", "Checkbox", array(
			"options"       => $options,
			"multiple"      => true,
			"title"         => __( "If the member has any of these memberships", "buddyboss-app" ),
			"empty_message" => __( "No memberships found.", "buddyboss-app" ),
		) );

		$this->load();
	}

	/**
	 * @param $r_users_ids
	 *
	 * @return array
	 */
	public function filter_users( $r_users_ids ): array {
		global $wpdb;

		$filter    = $this->get_filter_data_value( 'filter' );
		$users_ids = array();

		switch ( $filter ) {
			case 'membership_user_rcpro_level':
				$product_ids = (array) $this->get_filter_data_value( 'repro_level_select' );

				foreach ( $product_ids as $product_id ) {
					$_users_ids = rcp_get_memberships( array(
						'status'    => 'active',
						'object_id' => $product_id,
						'fields'    => 'user_id',
					) );
					$users_ids  = array_merge( $users_ids, $_users_ids );
				}

				$users_ids = array_unique( $users_ids );
				break;
		}

		if ( ! empty( $users_ids ) ) {
			return $users_ids;
		}

		return $r_users_ids;
	}

	/**
	 * Render script
	 */
	function render_script() {
		// TODO: Implement render_script() method.
	}
}
