<?php

namespace BuddyBossApp\Integrations\PmProMembership;

use BuddyBossApp\Integrations\PmPro\PmProMembershipSupport;
use BuddyBossApp\UserSegment\SegmentsAbstract as SegmentsAbstract;

class Segment extends SegmentsAbstract {

	/**
	 * Learndash constructor.
	 */
	public function __construct() {
		$this->add_filter( "membership", "user_pmpro_level", array( "pmpro_level_select" ) );

		// MemberPress Level.
		$options  = array();
		$products = PmProMembershipSupport::instance()->get_pmpro_levels();

		foreach ( $products as $product ) {
			$options[ $product->id ] = $product->name;
		}

		$this->add_field( "pmpro_level_select", "Checkbox", array(
			"options"       => $options,
			"multiple"      => true,
			"title"         => __( "If the member has any of these memberships", "buddyboss-app" ),
			"empty_message" => __( "No memberships found.", "buddyboss-app" ),
		) );

		$this->load();
	}

	/**
	 * @param $r_users_ids
	 *
	 * @return array
	 */
	public function filter_users( $r_users_ids ): array {
		global $wpdb;

		$filter    = $this->get_filter_data_value( 'filter' );
		$users_ids = array();

		switch ( $filter ) {
			case 'membership_user_pmpro_level':
				$product_ids = (array) $this->get_filter_data_value( 'pmpro_level_select' );
				$query       = "SELECT DISTINCT user_id FROM {$wpdb->pmpro_memberships_users} WHERE membership_id in (" . implode( ',', $product_ids ) . ") AND status=%s";
				$query       = $wpdb->prepare( $query, 'active' );
				$users_ids   = $wpdb->get_col( $query );
				break;
		}

		if ( ! empty( $users_ids ) ) {
			return $users_ids;
		}

		return $r_users_ids;
	}

	/**
	 * Render script
	 */
	function render_script() {
		// TODO: Implement render_script() method.
	}
}
