<?php

namespace BuddyBossApp\Integrations\PmPro;

use BuddyBossApp\Integrations\PmProMembership\Segment;
use BuddyBossApp\Tools\Logger;

class PmProMembershipSupport {

	private static $instance = null;

	/**
	 * PmProForumSupport constructor.
	 */
	public function __construct() {
		//Using Singleton, see instance()
	}

	/**
	 * Get the instance of the class.
	 * @return PmProMembershipSupport
	 */
	public static function instance() {

		if ( null === self::$instance ) {
			$className      = __CLASS__;
			self::$instance = new $className;
			self::$instance->load();
		}

		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {
		add_action( 'init', array( $this, "hook" ) );
	}

	/**
	 *
	 */
	public function hook() {
		// Only if pmpro-memberships plugin is active
		if ( defined( 'PMPRO_VERSION' ) ) {
			add_action( 'rest_api_init', array( $this, "rest_hook" ) );
			add_filter( 'bbapp_user_segment_integrations', array( $this, 'load_segment' ), 11 );
		}
	}

	/**
	 * Filter for rest api.
	 */
	public function rest_hook() {
		add_filter( "bbapp_menu_item_dependency",  array( $this, "filter_app_menu" ), 10, 2 );

		if ( defined( 'LEARNDASH_PMP_VERSION' ) && class_exists( 'Learndash_Paidmemberships' ) ) {
			/**
			 * Todo: Below methods are not Required as content restricting done by plugin itself. Before remove make cross verification.
			 * NOTE : Only courses are allowed membership level(learndash-paidmembershipspro plugin)
			 */
			// add_filter('bbapp_ld_rest_prepare_course', array($this, 'courseRestrictPmProRule'), 10, 3);
			// add_filter('bbapp_ld_rest_prepare_lesson', array($this, 'lessonRestrictPmProRule'), 10, 3);
			// add_filter('bbapp_ld_rest_prepare_topic', array($this, 'topicRestrictPmProRule'), 10, 3);
		}
	}

	/**
	 * Load Learndash related user segments
	 *
	 * @param $integrations
	 *
	 * @return mixed
	 */
	public function load_segment( $integrations ) {
		$integrations['pmpro_membership'] = new Segment();

		return $integrations;
	}

	/**
	 * Function: rule_content
	 *
	 * @param $response
	 * @param $post
	 * @param $request
	 *
	 * @return mixed
	 */
	public function courseRestrictPmProRule( $response, $post, $request ) {
		if ( WP_DEBUG ) {
			Logger::instance()->add( "info_log", "BuddyBossApp\Integrations\PmPro->courseRestrictPmProRule()" );
		}

		// NOTE : PmPro stores levels in option table in DB
		$coursePmProLevels = get_option( '_level_course_option' );
		$levelAsArray      = explode( ",", $coursePmProLevels[ $post->ID ] );

		$currentUserLevels = array();
		if ( function_exists( 'pmpro_getMembershipLevelsForUser' ) ) {
			$currentUserLevels = pmpro_getMembershipLevelsForUser();
		}

		$hasLevelAccess = false;
		foreach ( $currentUserLevels as $key => $currentUserLevel ) {
			if ( in_array( $currentUserLevel->ID, $levelAsArray ) ) {
				$hasLevelAccess = true;
			}
		}

		// NOTE : Purpose of this function is to verify if this content(post->ID) needs to be blocked/restricted
		if ( ! $hasLevelAccess ) {

			$response->data['has_course_access']  = false;
			$response->data['has_content_access'] = false;
			// content is blocked by 3rd party so all purchasable option should be blocked.
			$response->data['purchasable'] = true;

			if ( isset( $response->data['hide_content_table'] ) ) {
				$response->data['hide_content_table'] = true;
			}
			$response->data['error_message'] = array(
				'code'    => 'learndash_json_pm_pro_membership_course_access_invalid',
				'message' => '',
				'data'    => array( 'status' => 400 ),

			);
		}

		return $response;
	}

	/**
	 * Function: rule_content
	 *
	 * @param $response
	 * @param $post
	 * @param $request
	 *
	 * @return mixed
	 */
	public function lessonRestrictPmProRule( $response, $post, $request ) {
		if ( WP_DEBUG ) {
			Logger::instance()->add( "info_log", "BuddyBossApp\Integrations\PmPro->lessonRestrictPmProRule()" );
		}

		$uri = $_SERVER['REQUEST_URI'];

		// Check course access
		$course_id = bbapp_learndash_get_course_id( $post->ID );
		$course    = get_post( $course_id );
		$response  = $this->courseRestrictPmProRule( $response, $course, $uri );

		$userId = get_current_user_id();
		// TODO : Verify how pmPro integrates with LearnDash so we can retrieve permissions for lesson?
		if ( ! pmpro_hasMembershipLevel( $post->ID, $userId ) ) {
			$response->data['has_course_access_VERIFIED?']  = false;
			$response->data['has_content_access_VERIFIED?'] = false;
			$response->data['error_message_VERIFIED?']      = array(
				'code'    => 'learndash_json_pm_pro_membership_lesson_access_invalid',
				'message' => '',
				'data'    => array( 'status' => 400 ),

			);
		}

		return $response;
	}

	/**
	 * Restrict Page via menu to support PmProMembership
	 *
	 * @param $status
	 * @param $menu
	 *
	 * @return mixed
	 */
	public function filter_app_menu( $status, $menu ) {

		if ( WP_DEBUG ) {
			Logger::instance()->add( "info_log", "BuddyBossApp\Integrations\PmPro->filter_app_menu()" );
		}

		if ( 'page' == $menu['object'] ) {
			$hasAccess = pmpro_has_membership_access( $menu['data']['id'] );
			if ( ! $hasAccess ) {
				return false;
			}
		}

		return $status;
	}

	/**
	 * Get PM Pro levels.
	 *
	 * @since 2.4.10
	 * @return array|mixed|null
	 */
	public function get_pmpro_levels() {
		$include_hidden = apply_filters( 'bbapp_pmpro_include_hidden', false );

		return pmpro_getAllLevels( $include_hidden );
	}
}
