<?php

namespace BuddyBossApp\Integrations\PmPro;

use \BuddyBossApp\Tools\Logger;

class PmProForumSupport
{
    private static $instance = null;

    /**
     * PmProForumSupport constructor.
     */
    public function __construct()
    {
        //Using Singleton, see instance()
    }

    /**
     * Get the instance of the class.
     * @return object
     */
    public static function instance()
    {

        if (null === self::$instance) {
            $className = __CLASS__;
            self::$instance = new $className;
            self::$instance->init();
        }

        return self::$instance;
    }


    /**
     * Initialize actions/filters
     * @return void
     */
    public function init()
    {
        add_action('init', array($this, 'hooks'));
    }

    /**
     */
    public function hooks()
    {
        /**
         * Only if paid-memberships-pro(constant : PMPRO_VERSION) &
         * pmpro-bbpress(constant: PMPROBB_DIR)
         * bbpress(classname : bbPress)
         * plugins are active
         */
        if (defined('PMPRO_VERSION') && defined('PMPROBB_DIR') && class_exists('bbPress')) {
            add_filter("rest_prepare_forum", array($this, 'forumRestrictPmProRule'), 999, 3);
            add_filter("rest_prepare_topic", array($this, "topicRestrictPmProRule"), 9999, 3);
        }
    }

    /**
     * Restrict Forum for Mobile-App to support PmProMembership
     * @param $response
     * @param $post
     * @param $request
     * @return mixed
     */
    public function forumRestrictPmProRule($response, $post, $request)
    {

        if (WP_DEBUG) {
	        Logger::instance()->add("info_log", "BuddyBossApp\Integrations\PmProForumSupport->forumRestrictPmProRule()");
        }

        if (isset($response->data['current_user_permissions'])) {

            $hasAccess = pmpro_has_membership_access($post->ID);
            if (!$hasAccess) {
                $response->data['current_user_permissions']['show_subforum'] = false;
                $response->data['current_user_permissions']['show_topics'] = false;
                $response->data['current_user_permissions']['topic'] = false;
            }
        }

        return $response;
    }


    /**
     * Restrict Forum for Mobile-App to support PmProMembership
     * @param $response
     * @param $post
     * @param $request
     * @return mixed
     */
    public function topicRestrictPmProRule($response, $post, $request)
    {

        if (WP_DEBUG) {
	        Logger::instance()->add("info_log", "BuddyBossApp\Integrations\PmProForumSupport->topicRestrictPmProRule()");
        }

        if (isset($response->data['current_user_permissions'])) {
            $belongsToForumId = $response->data['forum_id'];
            $hasAccess = pmpro_has_membership_access($belongsToForumId);

            if (!$hasAccess) {
                $response->data['current_user_permissions']['show_replies'] = false;
                $response->data['current_user_permissions']['edit'] = false;
                $response->data['current_user_permissions']['moderate'] = false;
                $response->data['current_user_permissions']['reply'] = false;
                $response->data['current_user_permissions']['trash'] = false;
            }
        }

        return $response;
    }
}