<?php
namespace BuddyBossApp\Integrations\Memberium;

// Contains all bbpress related feature

class Main {

	private static $instance;

	/**
	 * Main constructor.
	 */
	public function __construct() {}

	public static function instance() {
		if (!isset(self::$instance)) {
			$class = __CLASS__;
			self::$instance = new $class;
			self::$instance->load(); // run the hooks.
		}
		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {
		add_action( 'init', array( $this, 'init') );
	}

	/**
	 *
	 */
	public function init(){
		if ( function_exists('memb_hasPostAccess') ) {
			add_filter( "bbapp_menu_item_dependency",  array( $this, "memberium_filter_appmenu" ), 10, 2 );
		}
	}

	/**
	 * @param $status
	 * @param $menu
	 * https://memberium.com/how-to-integrate-memberium-with-your-developers-php-code/

	 *
	 * @return array
	 */
	public function memberium_filter_appmenu( $status, $menu ) {
		if ( 'page' == $menu['object'] && function_exists( 'memb_hasPostAccess' ) ) {
			$is_access = memb_hasPostAccess( $menu['data']['id'] );
			if ( ! $is_access ) {
				return false;
			}
		}

		return $status;
	}

}