<?php

namespace BuddyBossApp\Integrations\Memberium;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

class AccessControls extends \BuddyBossApp\AccessControls\Integration_Abstract {

	/**
	 * @var string $_condition_name condition name.
	 */
	private $_condition_name = 'memberium';

	/**
	 * Function to set up the conditions.
	 *
	 * @since 1.5.2.1
	 *
	 * @return mixed|void
	 */
	public function setup() {
		$this->register_condition( array(
			'condition'              => $this->_condition_name,
			'items_callback'         => array( $this, 'memberium_membership_items_callback' ),
			'item_callback'          => array( $this, 'memberium_membership_item_callback' ),
			'users_callback'         => array( $this, 'memberium_membership_users_callback' ),
			'labels'                 => array(
				'condition_name'          => __( 'Memberium', 'buddyboss-app' ),
				'item_singular'           => __( 'Membership', 'buddyboss-app' ),
				'member_of_specific_item' => __( 'Has specific membership', 'buddyboss-app' ),
				'member_of_any_items'     => __( 'Has any membership', 'buddyboss-app' )
			),
			'support_any_items'      => true,
			'has_any_items_callback' => array( $this, 'has_any_items_callback' ),
		) );

	}

	/**
	 * Items callback method.
	 *
	 * @param string $search Search the condition.
	 * @param int    $page   Page number
	 * @param int    $limit  Limit the items to be fetched.
	 *
	 * @since 1.5.2.1
	 *
	 * @return array
	 */
	public function memberium_membership_items_callback( $search = '', $page = 1, $limit = 20 ) {
		$list = array();

		if ( defined( MEMBERIUM_SKU ) && defined( MEMBERIUM_MEMBERSHIP_SETTINGS ) && 'm4ac' === MEMBERIUM_SKU ) {
			$levels = get_option( MEMBERIUM_MEMBERSHIP_SETTINGS, array() );
		} else {
			$settings = get_option( 'memberium', [] );
			$levels   = ! empty( $settings['memberships'] ) ? $settings['memberships'] : array();
		}

		if ( ! empty( $levels ) ) {
			foreach ( $levels as $level_id => $level ) {
				$list[ $level_id ] = array(
					'id'   => $level_id,
					'name' => $level['name'],
					'link' => '#',
				);
			}
		}

		return $this->paginate_items_list( $list, $page, $limit, $search );
	}

	/**
	 * Item callback method.
	 *
	 * @param int $item_value Item value of condition.
	 *
	 * @since 1.5.2.1
	 *
	 * @return array|false
	 */
	public function memberium_membership_item_callback( $item_value ) {
		// We are in discussion with Memberium team to get this data.
	}

	/**
	 * Users callback method.
	 *
	 * @param array $data     condition data.
	 * @param int   $page     current page number.
	 * @param int   $per_page limit.
	 *
	 * @since 1.5.2.1
	 *
	 * @return array
	 */
	public function memberium_membership_users_callback( $condition_data, $page = 1, $per_page = 10 ) {
		// We are in discussion with Memberium team to get this data.
	}

	/**
	 * Function to check if user has any condition.
	 *
	 * @param int $user_id User id to check.
	 *
	 * @since 1.5.2.1
	 *
	 * @return bool
	 */
	public function has_any_items_callback( $user_id ) {
		// We are in discussion with Memberium team to get this data.
	}
}
