<?php
/**
 * Holds MemberPress LMS related features/hooks/filters.
 *
 * @package BuddyBossApp\Integrations\MemberPressCourses
 */

namespace BuddyBossApp\Integrations\MemberPressCourses;

use BuddyBossApp\UserSegment\SegmentsAbstract;

/**
 * MemberPress LMS related features/hooks/filters.
 *
 * @since 2.2.80
 */
class Segment extends SegmentsAbstract {

	/**
	 * MemberPress LMS constructor.
	 *
	 * @since 2.2.80
	 */
	public function __construct() {
		// Course.
		$this->add_filter( 'memberpress_lms', 'user_memberpress_course', array( 'memberpress_course_select' ) );
		$course_options = array();
		$courses_query  = new \WP_Query(
			array(
				'post_type'   => 'mpcs-course',
				'fields'      => 'ids',
				'nopaging'    => true,
				'orderby'     => 'name',
				'order'       => 'asc',
				'post_status' => array( 'publish' ),
			)
		);
		if ( $courses_query->have_posts() ) {
			foreach ( $courses_query->posts as $course ) {
				$course_options[ $course ] = get_the_title( $course );
			}
		}
		$this->add_field(
			'memberpress_course_select',
			'Checkbox',
			array(
				'options'       => $course_options,
				'multiple'      => true,
				'title'         => __( 'If the member is enrolled in any of these MemberPress courses', 'buddyboss-app' ),
				'empty_message' => __( 'No courses found.', 'buddyboss-app' ),
			)
		);

		$this->load();
	}

	/**
	 * Return Filtered Users.
	 *
	 * @param array $r_users_ids User ids.
	 *
	 * @since 2.2.80
	 * @return array
	 */
	public function filter_users( $r_users_ids ) {
		$filter    = $this->get_filter_data_value( 'filter' );
		$users_ids = array();

		switch ( $filter ) {
			case 'memberpress_lms_user_memberpress_course':
				$course_ids = (array) $this->get_filter_data_value( 'memberpress_course_select' );

				foreach ( $course_ids as $course_id ) {
					if ( ! empty( $course_id ) ) {
						if ( class_exists( 'memberpress\courses\models\UserProgress' ) ) {
							$users_ids = \memberpress\courses\models\UserProgress::find_all_course_participants( $course_id );
						}
					}
				}

				$users_ids = array_unique( $users_ids );
				break;
		}

		if ( ! empty( $users_ids ) ) {
			return $users_ids;
		}

		return $r_users_ids;
	}

	/**
	 * Render script
	 *
	 * @since 2.2.80
	 */
	public function render_script() {
		// TODO: Implement render_script() method.
	}
}
