<?php

namespace BuddyBossApp\Integrations\MemberPress;

use BuddyBossApp\UserSegment\SegmentsAbstract as SegmentsAbstract;

class Segment extends SegmentsAbstract {

	/**
	 * Learndash constructor.
	 */
	public function __construct() {

		$this->add_filter( "membership", "user_memberpress_level", array( "memberpress_level_select" ) );

		// MemberPress Level
		$options = array();
		if ( class_exists( '\MeprCptModel' ) ) {
			$products = \MeprCptModel::all( 'MeprProduct' );
			foreach ( $products as $product ) {
				$options[ $product->ID ] = get_the_title( $product->ID );
			}
			$this->add_field( "memberpress_level_select", "Checkbox", array(
				"options"       => $options,
				"multiple"      => true,
				"title"         => __( "If the member has any of these memberships", "buddyboss-app" ),
				"empty_message" => __( "No memberships found.", "buddyboss-app" ),
			) );
		}

		$this->load();
	}

	/**
	 * @param $r_users_ids
	 *
	 * @return array
	 */
	public function filter_users( $r_users_ids ): array {
		global $wpdb;

		$filter    = $this->get_filter_data_value( 'filter' );
		$users_ids = array();

		switch ( $filter ) {
			case 'membership_user_memberpress_level':
				$product_ids = (array) $this->get_filter_data_value( 'memberpress_level_select' );

				$mepr_db   = new \MeprDb();
				$query     = "SELECT DISTINCT user_id FROM {$mepr_db->transactions} WHERE product_id in (" . implode( ',', $product_ids ) . ") AND txn_type=%s AND status=%s";
				$query     = $wpdb->prepare( $query, \MeprTransaction::$payment_str, \MeprTransaction::$complete_str );
				$users_ids = $wpdb->get_col( $query );

				break;
		}

		if ( ! empty( $users_ids ) ) {
			return $users_ids;
		}

		return $r_users_ids;
	}

	/**
	 * Render script
	 */
	function render_script() {
		// TODO: Implement render_script() method.
	}
}
