<?php

namespace BuddyBossApp\Integrations\MemberPress;

use MeprHooks;
use MeprRule;
use MeprRulesCtrl;

class Main {

	private static $instance;

	/**
	 * MemberPress constructor.
	 */
	public function __construct() {
		//Using Singleton, see instance()
	}

	/**
	 * @return Main
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
			self::$instance->load(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {
		add_action( 'init', array( $this, "hook" ) );
	}

	/**
	 *
	 */
	public function hook() {
		if ( defined( 'MEPR_VERSION' ) && class_exists( 'MeprCtrlFactory' ) ) {
			add_action( 'rest_api_init', array( $this, "rest_hook" ) );
			add_filter( 'bbapp_user_segment_integrations', array( $this, 'load_segment' ), 11 );
			add_action( 'bbapp_auth_wp_login', array( $this, 'bbapp_mper_track_login'), 10, 3 );
		}
	}

	/**
	 * Filter for rest api.
	 */
	public function rest_hook() {
		add_filter( 'bbapp_ld_rest_prepare_course', array( $this, 'course_restrict_memberpress_rule' ), 10, 3 );
		add_filter( 'bbapp_ld_rest_prepare_lesson', array( $this, 'lesson_restrict_memberpress_rule' ), 10, 3 );
		add_filter( 'bbapp_ld_rest_prepare_topic', array( $this, 'topic_restrict_memberpress_rule' ), 10, 3 );
	}

	/**
	 * Load Learndash related user segments
	 *
	 * @param $integrations
	 *
	 * @return mixed
	 */
	public function load_segment( $integrations ) {
		$integrations['memberpress'] = new Segment();

		return $integrations;
	}

	/**
	 * memberpress/app/controllers/MeprRulesCtrl.php
	 * Function: rule_content
	 *
	 * @param $response
	 * @param $post
	 * @param $request
	 *
	 * @return mixed
	 */
	public function course_restrict_memberpress_rule( $response, $post, $request ) {
		$uri = $_SERVER['REQUEST_URI'];
		if ( ! class_exists( 'MeprHooks' ) || ! class_exists( 'MeprRule' ) ) {
			return $response;
		}

		if ( ! MeprHooks::apply_filters( 'mepr-pre-run-rule-content', true, $post, $uri ) ) {
			return $response;
		}

		if ( MeprRule::is_locked( $post ) || ( MeprRule::is_uri_locked( $uri ) ) ) {

			$response->data['has_course_access']  = false;
			$response->data['has_content_access'] = false;
			// content is block by 3rd party so all purchasable option should be blocked.
			$response->data['purchasable'] = false;

			if ( isset( $response->data['hide_content_table'] ) ) {
				$response->data['hide_content_table'] = true;
			}

			// TODO : Typo with 'code' value, when should we fix it, will it break mobile app?
			$response->data['error_message'] = array(
				'code'    => 'learndash_json_memberpress_course_access_invaild',
				'message' => do_shortcode( MeprRulesCtrl::unauthorized_message( $post ) ),
				'data'    => array( 'status' => 400 ),

			);

		} else {

			//The user is allowed to see this content, but let's give developers one last chance to
			//block it if necessary - will be very helpful for magazine style membership sites
			//return TRUE here to block the content from this user
			if ( MeprHooks::apply_filters( 'mepr-last-chance-to-block-content', false, $post, $uri ) ) {
				$response->data['has_course_access']  = false;
				$response->data['has_content_access'] = false;
				// content is block by 3rd party so all purchasable option should be blocked.
				$response->data['purchasable'] = false;

				if ( isset( $response->data['hide_content_table'] ) ) {
					$response->data['hide_content_table'] = true;
				}

				// TODO : Typo with 'code' value, when should we fix it, will it break mobile app?
				$response->data['error_message'] = array(
					'code'    => 'learndash_json_memberpress_course_access_invaild',
					'message' => do_shortcode( MeprRulesCtrl::unauthorized_message( $post ) ),
					'data'    => array( 'status' => 400 ),

				);
			}

		}

		return $response;
	}

	/**
	 * memberpress/app/controllers/MeprRulesCtrl.php
	 * Function: rule_content
	 *
	 * @param $response
	 * @param $post
	 * @param $request
	 *
	 * @return mixed
	 */
	public function lesson_restrict_memberpress_rule( $response, $post, $request ) {

		$uri = $_SERVER['REQUEST_URI'];
		if ( ! class_exists( 'MeprHooks' ) ) {
			return $response;
		}

		if ( ! MeprHooks::apply_filters( 'mepr-pre-run-rule-content', true, $post, $uri ) ) {
			return $response;
		}

		//Check course access
		$course_id = bbapp_learndash_get_course_id( $post->ID );
		$course    = get_post( $course_id );
		$response  = $this->course_restrict_memberpress_rule( $response, $course, $uri );

		if ( MeprRule::is_locked( $post ) || ( MeprRule::is_uri_locked( $uri ) ) ) {
			$response->data['has_course_access']  = false;
			$response->data['has_content_access'] = false;

			$response->data['error_message'] = array(
				'code'    => 'learndash_json_memberpress_lesson_access_invaild',
				'message' => do_shortcode( MeprRulesCtrl::unauthorized_message( $post ) ),
				'data'    => array( 'status' => 400 ),

			);
		} else {
			//The user is allowed to see this content, but let's give developers one last chance to
			//block it if necessary - will be very helpful for magazine style membership sites
			//return TRUE here to block the content from this user
			if ( MeprHooks::apply_filters( 'mepr-last-chance-to-block-content', false, $post, $uri ) ) {
				$response->data['has_course_access']  = false;
				$response->data['has_content_access'] = false;
				$response->data['purchasable']        = false;

				$response->data['error_message'] = array(
					'code'    => 'learndash_json_memberpress_lesson_access_invaild',
					'message' => do_shortcode( MeprRulesCtrl::unauthorized_message( $post ) ),
					'data'    => array( 'status' => 400 ),

				);
			}
		}

		return $response;
	}

	/**
	 * memberpress/app/controllers/MeprRulesCtrl.php
	 * Funcation: rule_content
	 *
	 * @param $response
	 * @param $post
	 * @param $request
	 *
	 * @return mixed
	 */
	public function topic_restrict_memberpress_rule( $response, $post, $request ) {
		$uri = $_SERVER['REQUEST_URI'];
		if ( ! class_exists( 'MeprHooks' ) ) {
			return $response;
		}

		if ( ! MeprHooks::apply_filters( 'mepr-pre-run-rule-content', true, $post, $uri ) ) {
			return $response;
		}

		//Check course/lesson access
		$lesson_id = bbapp_learndash_get_lesson_id( $post->ID );
		$lesson    = get_post( $lesson_id );
		$response  = $this->course_restrict_memberpress_rule( $response, $lesson, $uri );

		if ( MeprRule::is_locked( $post ) || ( MeprRule::is_uri_locked( $uri ) ) ) {
			$response->data['has_course_access']  = false;
			$response->data['has_content_access'] = false;

			$response->data['error_message'] = array(
				'code'    => 'learndash_json_memberpress_topic_access_invaild',
				'message' => do_shortcode( MeprRulesCtrl::unauthorized_message( $post ) ),
				'data'    => array( 'status' => 400 ),

			);
		} else {
			//The user is allowed to see this content, but let's give developers one last chance to
			//block it if necessary - will be very helpful for magazine style membership sites
			//return TRUE here to block the content from this user
			if ( MeprHooks::apply_filters( 'mepr-last-chance-to-block-content', false, $post, $uri ) ) {
				$response->data['has_course_access']  = false;
				$response->data['has_content_access'] = false;
				$response->data['error_message']      = array(
					'code'    => 'learndash_json_memberpress_topic_access_invaild',
					'message' => do_shortcode( MeprRulesCtrl::unauthorized_message( $post ) ),
					'data'    => array( 'status' => 400 ),

				);
			}
		}

		return $response;
	}

	/**
	 * Track login, when user logged in from the app.
	 *
	 * @param string $user_login User login
	 * @param object $user       User object.
	 *
	 * @since 1.5.6
	 */
    public function bbapp_mper_track_login( $user_login, $user ) {
		//Track this login, then get the num total logins for this user
		$wp_user = new \MeprUser( $user->ID );
        \MeprEvent::record( 'login', $wp_user );
    }
}
