<?php

namespace BuddyBossApp\Integrations\LearndashBuddyPress;
// Contains all Learndash BuddyPress related feature
class Main {

	private static $instance;

	/**
	 * Main constructor.
	 */
	public function __construct() {
	}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
			self::$instance->load(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {
		add_action( 'rest_api_init', array( $this, "hook" ) );
	}

	/**
	 *
	 */
	public function hook() {
		add_filter( 'bbapp_ld_get_courses', array( $this, 'update_objects' ), 20 );
		add_filter( 'bbapp_ld_get_course', array( $this, 'update_object' ), 20 );
	}

	/**
	 * @param $result
	 *
	 * @return mixed
	 */
	public function update_objects( $result ) {

		if ( ! function_exists( 'buddypress' ) || ! bp_is_active( 'groups' ) ) {
			return $result;
		}

		foreach ( $result['posts'] as $key => $post ) {
			$result['posts'][ $key ] = $this->update_object( $post );
		}

		return $result;
	}

	/**
	 * @param $post
	 *
	 * @return mixed
	 */
	public function update_object( $post ) {
		if ( ! function_exists( 'buddypress' ) || ! bp_is_active( 'groups' ) ) {
			return $post;
		}
		if ( function_exists( 'bbp_get_group_forum_ids' ) ) {
			$group_id = get_post_meta( $post->ID, 'bp_course_group', true );
			if ( ! empty( $group_id ) ) {
				$post->group = (int) $group_id;
				if ( ! empty( $group_id ) ) {
					$forum_ids = bbp_get_group_forum_ids( $group_id );
					if ( ! empty( $forum_ids ) ) {
						$forum_id    = (int) ( is_array( $forum_ids ) ? $forum_ids[0] : $forum_ids );
						$post->forum = $forum_id;
					}
				}
			}
		}

		return $post;
	}
}
