<?php

namespace BuddyBossApp\Integrations\LearndashBoss;
// Contains all Learndash bbpress related feature
class Main {

	private static $instance;

	/**
	 * Main constructor.
	 */
	public function __construct() {
	}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
			self::$instance->load(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {
		add_action( 'rest_api_init', array( $this, "hook" ) );
	}

	/**
	 *
	 */
	public function hook() {

		if ( defined( 'BOSS_LEARNDASH_PLUGIN_VERSION' ) ) {

			add_filter( 'bbapp_ld_get_courses', array( $this, 'update_objects_video' ), 20 );
			add_filter( 'bbapp_ld_get_lessons', array( $this, 'update_objects_video' ), 20 );
			add_filter( 'bbapp_ld_get_topics', array( $this, 'update_objects_video' ), 20 );
			add_filter( 'bbapp_ld_get_course', array( $this, 'update_object_video' ), 20 );
			add_filter( 'bbapp_ld_get_lesson', array( $this, 'update_object_video' ), 20 );
			add_filter( 'bbapp_ld_get_topic', array( $this, 'update_object_video' ), 20 );
		}
	}

	/**
	 * @param $result
	 *
	 * @return mixed
	 */
	public function update_objects_video( $result ) {
		foreach ( $result['posts'] as $key => $post ) {
			if ( empty( $post->ID ) ) {
				continue;
			}
			if ( ! isset( $post->video ) || empty( $post->video ) ) {
				$course_video_embed             = get_post_meta( $post->ID, '_boss_edu_post_video', true );
				$result['posts'][ $key ]->video = $course_video_embed;
			}
		}

		return $result;
	}

	/**
	 * @param $post
	 *
	 * @return mixed
	 */
	public function update_object_video( $post ) {
		if ( empty( $post->ID ) ) {
			return $post;
		}
		if ( ! isset( $post->video ) || empty( $post->video ) ) {
			$course_video_embed = get_post_meta( $post->ID, '_boss_edu_post_video', true );
			$post->video        = $course_video_embed;
		}

		return $post;
	}
}
