<?php

namespace BuddyBossApp\Integrations\LearndashBBPress;
// Contains all Learndash bbpress related feature
class Main {

	private static $instance;

	/**
	 * Main constructor.
	 */
	public function __construct() {
	}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
			self::$instance->load(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {
		add_action( 'rest_api_init', array( $this, "hook" ) );
	}

	public function hook() {
		if ( class_exists( 'Learndash_BBPress' ) ) {
			add_filter( 'ld_forum_access_restricted_message', array( $this, 'ldForumAccessRestrictedMessage' ), 99, 3 );
		}
	}

	/**
	 * Learndash bbpress plugin print error message directly so we need to remove it for rest.
	 *
	 * @param $content
	 *
	 * @return string
	 */
	public function ldForumAccessRestrictedMessage( $content ) {
		return '';
	}
}
