<?php
/**
 * Holds Learndash related features/hooks/filters.
 *
 * @package BuddyBossApp\Integrations\Learndash
 */

namespace BuddyBossApp\Integrations\Learndash;

use BuddyBossApp\UserSegment\SegmentsAbstract as SegmentsAbstract;
/**
 * Learndash related features/hooks/filters.
 */
class Segment extends SegmentsAbstract {

	/**
	 * Learndash constructor.
	 */
	public function __construct() {

		// Course.
		$this->add_filter( 'learndash', 'user_learndash_course', array( 'learndash_course_select' ) );
		$course_options = array();
		$courses_query  = new \WP_Query(
			array(
				'post_type'   => 'sfwd-courses',
				'fields'      => 'ids',
				'nopaging'    => true,
				'orderby'     => 'name',
				'order'       => 'asc',
				'post_status' => array( 'publish' ),
			)
		);
		if ( $courses_query->have_posts() ) {
			foreach ( $courses_query->posts as $course ) {
				$course_options[ $course ] = get_the_title( $course );
			}
		}
		$this->add_field(
			'learndash_course_select',
			'Checkbox',
			array(
				'options'       => $course_options,
				'multiple'      => true,
				'title'         => __( 'If the member is enrolled in any of these LearnDash courses', 'buddyboss-app' ),
				'empty_message' => __( 'No courses found.', 'buddyboss-app' ),
			)
		);

		$this->add_filter( 'membership', 'user_learndash_group', array( 'learndash_group_select' ) );
		// Group.
		$group_options = array();
		$group_ids     = learndash_get_groups( true );
		foreach ( $group_ids as $group_id ) {
			$group_options[ $group_id ] = get_the_title( $group_id );
		}
		$this->add_field(
			'learndash_group_select',
			'Checkbox',
			array(
				'options'       => $group_options,
				'multiple'      => true,
				'title'         => __( 'If the member has any of these memberships', 'buddyboss-app' ),
				'empty_message' => __( 'No memberships found.', 'buddyboss-app' ),
			)
		);

		$this->load();
	}

	/**
	 * Return Filtered Users.
	 *
	 * @param array $r_users_ids User ids.
	 *
	 * @return array
	 */
	public function filter_users( $r_users_ids ) {

		$filter    = $this->get_filter_data_value( 'filter' );
		$users_ids = array();

		switch ( $filter ) {
			case 'learndash_user_learndash_course':
				$course_ids = (array) $this->get_filter_data_value( 'learndash_course_select' );

				foreach ( $course_ids as $course_id ) {
					if ( ! empty( $course_id ) ) {
						$members_arr = learndash_get_users_for_course( $course_id, array(), false );
						if ( ( $members_arr instanceof \WP_User_Query ) && ( property_exists( $members_arr, 'results' ) ) && ( ! empty( $members_arr->results ) ) ) {
							$_users_ids = $members_arr->get_results();
							$users_ids  = array_merge( $users_ids, $_users_ids );
						}
					}
				}

				$users_ids = array_unique( $users_ids );
				break;
			case 'membership_user_learndash_group':
				$group_ids = $this->get_filter_data_value( 'learndash_group_select' );

				foreach ( $group_ids as $group_id ) {
					if ( ! empty( $group_id ) ) {
						$_users_ids = learndash_get_groups_user_ids( $group_id );
						$users_ids  = array_merge( $users_ids, $_users_ids );
					}
				}

				$users_ids = array_unique( $users_ids );
				break;
		}

		if ( ! empty( $users_ids ) ) {
			return $users_ids;
		}

		return $r_users_ids;
	}

	/**
	 * Render script
	 */
	public function render_script() {
		// TODO: Implement render_script() method.
	}
}
