<?php
/**
 * Holds Learndash Course field Selection.
 *
 * @package BuddyBossApp\UserSegment\Fields
 */

namespace BuddyBossApp\UserSegment\Fields;

/**
 * Learndash Course field Selection.
 */
class LDCourseSelect {

	/**
	 * Overriding the parent(from base-class) function.
	 *
	 * @param string $field_name Field name.
	 * @param array  $args Fields arrguments.
	 */
	public static function render( $field_name, $args = array() ) {
		$before_label = isset( $args['before_label'] ) ? $args['before_label'] : '';
		?>
		<span class="bbapp_usegment_field_ldcourseselect">
			<?php if ( ! empty( $before_label ) ) : ?>
				<label><?php echo esc_html( $before_label ); ?></label>
			<?php endif; ?>
			<select name="<?php echo esc_html( $field_name ); ?>[{{data._index}}]">
				<option value=""><?php esc_html_e( 'Select Course', 'buddyboss-app' ); ?></option>
			</select>
		</span>
		<?php

	}

	/**
	 * Render the part outside of template. idea for js & css for fields specific.
	 */
	public static function render_script() {
		static $output_once;

		// avoid function to exec twice.
		if ( isset( $output_once ) ) {
			return false;
		}
		?>
		<script>
			/**
			 * Load LD course select.
			 */
			function bbappSegmentLdcourseSelectInit() {
				jQuery( '.bbapp_usegment_field_ldcourseselect' ).each( function() {
					if ( jQuery( this ).data( 'processed' ) === '1' ) {
						return true;
					}

					jQuery( this ).data( 'processed', '1' );

					const select = jQuery( this ).find( 'select' );

					jQuery( select ).select2( {
						formatSelection( item ) {
							return item.id;
						},
						dropdownAutoWidth: true,
						width: 'auto',
						tags: [],
						ajax: {
							headers: {
								'X-WP-Nonce': bbappAjax.rest_nonce,
							},
							url: bbappAjax.resturl + 'buddyboss-app/learndash/v1/courses',
							dataType: 'json',
							type: 'GET',
							quietMillis: 50,
							data( term ) {
								return {
									search: term.term,
								};
							},
							processResults( data ) {
								return {
									results: jQuery.map( data, function( item ) {
										return {
											text: jQuery( '<div/>' ).html( item.title.rendered ).text(),
											id: item.id,
										};
									} ),
								};
							},
						},
					} );
				} );
			}

			jQuery( document ).ready( function() {
				jQuery( document ).on( '.choose_filter, .choose_sub_filter' ).change( function() {
					bbappSegmentLdcourseSelectInit();
				} );
			} );
		</script>
		<?php
	}
}
