<?php
/**
 * Holds LearnDash functionality related Access Controls.
 *
 * @package BuddyBossApp\Integrations\Learndash
 */

namespace BuddyBossApp\Integrations\Learndash;

use BuddyBossApp\AccessControls\Core\Core;
use BuddyBossApp\Admin\SetupAdmin;
use BuddyBossApp\Integrations\Learndash\AccessControls\Course;
use BuddyBossApp\Integrations\Learndash\AccessControls\LDCourse;
use BuddyBossApp\Integrations\Learndash\AccessControls\LDGroup;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * LearnDash Access Controls class.
 */
class AccessControls extends \BuddyBossApp\AccessControls\Integration_Abstract {

	/**
	 * Function to set up the conditions.
	 *
	 * @since 1.5.2.1
	 *
	 * @return mixed|void
	 */
	public function setup() {
		add_action( 'admin_init', array( $this, 'admin_init' ), 15 );

		// Register Conditions.
		$this->register_condition(
			array(
				'condition'              => LDCourse::instance()->condition_name,
				'items_callback'         => array( LDCourse::instance(), 'learndash_course_items_callback' ),
				'item_callback'          => array( LDCourse::instance(), 'learndash_course_item_callback' ),
				'users_callback'         => array( LDCourse::instance(), 'learndash_course_users_callback' ),
				'labels'                 => array(
					'condition_name'          => __( 'LearnDash Courses', 'buddyboss-app' ),
					'item_singular'           => __( 'Course', 'buddyboss-app' ),
					'member_of_specific_item' => __( 'Enrolled in a specific course', 'buddyboss-app' ),
					'member_of_any_items'     => __( 'Enrolled in any course', 'buddyboss-app' ),
				),
				'support_any_items'      => true,
				'has_any_items_callback' => array( LDCourse::instance(), 'has_any_items_callback' ),
			)
		);

		$this->register_condition(
			array(
				'condition'              => LDGroup::instance()->condition_name,
				'items_callback'         => array( LDGroup::instance(), 'learndash_group_items_callback' ),
				'item_callback'          => array( LDGroup::instance(), 'learndash_group_item_callback' ),
				'users_callback'         => array( LDGroup::instance(), 'learndash_group_users_callback' ),
				'labels'                 => array(
					'condition_name'          => __( 'LearnDash Groups', 'buddyboss-app' ),
					'item_singular'           => __( 'Group', 'buddyboss-app' ),
					'member_of_specific_item' => __( 'Member of a specific group', 'buddyboss-app' ),
					'member_of_any_items'     => __( 'Member of any group', 'buddyboss-app' ),
				),
				'support_any_items'      => true,
				'has_any_items_callback' => array( LDGroup::instance(), 'has_any_items_callback' ),
			)
		);

		// Register Rules Item Type.
		$this->register_rules_item_type( 'sfwd-courses' );
		$this->register_rules_item_type( 'sfwd-courses_term' );
		$this->register_rules_item_type( 'default_ld_course' );

		LDCourse::instance()->load_screens_settings();
		$this->load_hooks();
		// run job hook. (not empty meta run the job.).
	}


	/**
	 * Load Access Controls.
	 *
	 * @since 1.5.2.1
	 *
	 * @return void
	 */
	public function admin_init() {
		$page_get = ( ! empty( $_GET['page'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['page'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

		if ( 'admin.php' === SetupAdmin::instance()->get_page_now() && ! empty( $page_get ) && 'bbapp-access-controls' === $page_get ) {
			if ( 'courses' === Core::instance()->get_current_tab() && bbapp_is_admin_page() ) {
				Course::instance()->will_render( true );
			}
		}
	}


	/**
	 * Function to load all hooks of this condition.
	 *
	 * @since 1.5.2.1
	 */
	public function load_hooks() {
		// *******************************************************************//
		// ********************* LearnDash Course hooks **********************//
		// *******************************************************************//
		add_action(
			'learndash_update_course_access',
			array(
				LDCourse::instance(),
				'bbapp_learndash_update_course_access',
			),
			10,
			4
		);
		add_action(
			'transition_post_status',
			array(
				LDCourse::instance(),
				'bbapp_remove_learndash_access_control_data',
			),
			10,
			3
		);
		add_action( 'user_register', array( LDCourse::instance(), 'ld_register_user_success' ), 10, 1 );
		// triggers when user activation process happens.
		add_action( 'bp_core_activated_user', array( LDCourse::instance(), 'core_activated_user' ), 99, 3 );
		add_action( 'wpmu_activate_user', array( LDCourse::instance(), 'core_activated_user' ), 99, 3 );
		add_action( 'updated_postmeta', array( LDCourse::instance(), 'course_price_type_update' ), 10, 4 );

		// Background Job.
		add_action( 'bbapp_queue_task_ld_enrolled_course', array( LDCourse::instance(), 'user_enrolled_for_open_courses_job' ), 10, 1 );

		// *******************************************************************//
		// *********************** LearnDash Group hooks *********************//
		// *******************************************************************//
		add_action( 'ld_added_group_access', array( LDGroup::instance(), 'bbapp_ld_added_group_access' ), 10, 2 );
		add_action( 'ld_added_leader_group_access', array( LDGroup::instance(), 'bbapp_ld_added_group_access' ), 10, 2 );
		add_action( 'ld_removed_group_access', array( LDGroup::instance(), 'bbapp_ld_removed_group_access' ), 10, 2 );
		add_action( 'ld_removed_leader_group_access', array( LDGroup::instance(), 'bbapp_ld_removed_group_access' ), 10, 2 );
		add_action(
			'transition_post_status',
			array(
				LDGroup::instance(),
				'bbapp_remove_ld_group_access_control_data',
			),
			10,
			3
		);
	}
}
