<?php

namespace BuddyBossApp\Integrations\H5P;

// Contains all h5p plugin related feature
use H5P_Plugin;

class Main {

	private static $instance;

	/**
	 * Main constructor.
	 */
	public function __construct() {
	}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
			self::$instance->load(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {
		RestAPI::instance();
		$this->hooks();

	}

	/**
	 * Define all Hooks.
	 */
	public function hooks() {
		add_action( 'init', array( $this, 'gutenberg_h5p_block' ) );
	}

	/**
	 * Register H5P block.
	 */
	public function gutenberg_h5p_block() {

		if ( ! function_exists( 'register_block_type' ) || ! class_exists( 'H5P_Plugin' ) ) {
			// Gutenberg is not active OR H5P Plugin is not active.
			return;
		}
		register_block_type( 'bbapp/h5p', array(
			'editor_script'   => bbapp()->plugin_prefix . 'gutenberg',
			'render_callback' => array( $this, 'render_bbapp_h5p_block' ),
			'attributes'      => array(
				'title'        => array(
					'type'    => 'string',
					'default' => '',
				),
				'content_type' => array(
					'type'    => 'string',
					'default' => '',
				),
				'h5p_id'       => array(
					'default' => 0,
				),
				'h5p_items'    => array(
					'default' => array(),
				),
			),
		) );
	}

	/**
	 * Server side render H5P Block html.
	 *
	 * @param $block_attributes
	 *
	 * @return string
	 * @throws \Exception
	 */
	public function render_bbapp_h5p_block( $block_attributes ) {
		if ( ! empty( $block_attributes['h5p_id'] ) ) {
			$h5pId       = $block_attributes['h5p_id'];
			$plugin      = H5P_Plugin::get_instance();
			$content     = $plugin->get_content( $h5pId );
			$h5p_type_id = ( isset( $content["library"] ) && isset( $content["library"]["name"] ) ) ? $content["library"]["name"] : "";

			if ( ! in_array( $h5p_type_id, $this->unsupported_content_type_in_mobile() ) ) {
				$html    = '';
				if ( is_array( $content ) ) {
					$content_settings = $plugin->get_content_settings( $content );
					if ( ! empty( $content_settings['embedCode'] && ! empty( $content_settings['resizeCode'] ) ) ) {
						$html .= $content_settings['embedCode'];
						$html .= $content_settings['resizeCode'];
					}

					$is_edit_post = ( strpos( $_SERVER['HTTP_REFERER'], "edit.php" ) !== false || isset( $_GET['_locale'] ) );
					if ( defined( 'REST_REQUEST' ) && REST_REQUEST && $is_edit_post ) {
						$html .= "<div style='text-align: center;position: absolute;top: 0;left: 0;background: #fff;width: 100%;height: 100%;opacity: 0.6;'></div><div style='position: absolute;width: 100%;left: 0;height: 100%;top: 0;'><button class='components-button is-primary' style='top: 50%;transform: translate(-50%,-50%);left: 50%;position: absolute;'><span class='dashicons dashicons-controls-play'></span> {$block_attributes['title']}</button></div>";
					}
				}
				if ( '' == $html ) {
					return '<div class="h5p-placeholder">' . __( 'Select H5P content from the block settings.', 'buddyboss-app' ) . '</div>';
				}

				return $html;
			} else {
				$html    = '';
				return sprintf( __( '<div class="h5p-placeholder">This <strong>%s</strong> content type is not supported in BuddyBoss App.</div>', 'buddyboss-app' ), $block_attributes['content_type'] );
			}
		}

		return '<div class="h5p-placeholder">' . __( 'Select H5P content from the block settings.', 'buddyboss-app' ) . '</div>';
	}

	/**
	 * UnSupported content type list.
	 *
	 * @return string[]
	 */
	public function unsupported_content_type_in_mobile() {
		return array( 'H5P.SpeakTheWords', 'H5P.SpeakTheWordsSet', 'H5P.AudioRecorder' );
	}
}