<?php
namespace BuddyBossApp\Integrations\GoogleCaptcha;

/**
 * Contains all Google Captcha plugin related features/hooks/filters
 *
 * Class Main
 *
 * @package BuddyBossApp\Integrations\GoogleCaptcha
 */
class Main {

	private static $instance;

	/**
	 * Main constructor.
	 */
	public function __construct() {}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if (!isset(self::$instance)) {
			$class = __CLASS__;
			self::$instance = new $class;
			self::$instance->load(); // run the hooks.
		}
		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {
		add_action( 'rest_api_init', array( $this, 'remove_hook' ), 10 );
	}

	/**
	 * reCaptcha by BestWebSoft (Google Captcha) plugin support.
	 */
	public function remove_hook() {
		if ( function_exists( 'gglcptch_is_recaptcha_required' ) ) {
			$is_user_logged_in = is_user_logged_in();
			if ( gglcptch_is_recaptcha_required( 'login_form', $is_user_logged_in ) ) {
				remove_action( 'authenticate', 'gglcptch_login_check', 21 ); // Login screen.
			}
			if ( gglcptch_is_recaptcha_required( 'reset_pwd_form', $is_user_logged_in ) ) {
				remove_action( 'allow_password_reset', 'gglcptch_lostpassword_check' ); // Forget password screen.
			}
		}
	}

}