<?php
namespace BuddyBossApp\Integrations\ForceLogin;

// All Force login related changes
use WP_Error;

class Main {

	private static $instance;

	/**
	 * Main constructor.
	 */
	public function __construct() {}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if (!isset(self::$instance)) {
			$class = __CLASS__;
			self::$instance = new $class;
			self::$instance->load(); // run the hooks.
		}
		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {
		add_action( 'init', array( $this, 'init') );
	}

	/**
	 * Removing rest restriction hook from force login plugin and added code to bypass
	 */
	public function init(){
		if( function_exists( 'v_forcelogin_rest_access' ) ) {
            remove_filter( 'rest_authentication_errors', 'v_forcelogin_rest_access', 99 );
            add_filter( 'rest_authentication_errors', array( $this, 'vForceloginRestAccess' ), 99 );
		}
	}

    /**
     * Restrict REST API for authorized users only
     *
     * @param WP_Error|null|bool $result WP_Error if authentication error, null if authentication
     *                              method wasn't used, true if authentication succeeded.
     * @return WP_Error|bool|null
     * @since 5.1.0
     */
    public  function vForceloginRestAccess( $result ) {
        if ( null === $result && ! is_user_logged_in() && ! ( defined( 'REST_REQUEST' ) && REST_REQUEST ) ) {
            return new WP_Error( 'rest_unauthorized', __( "Only authenticated users can access the REST API.", 'wp-force-login' ), array( 'status' => rest_authorization_required_code() ) );
        }
        return $result;
    }


}