<?php

namespace BuddyBossApp\Integrations\DiviTheme;
// Contains all Divi Theme related feature
class Main {

	private static $instance;

	/**
	 * Main constructor.
	 */
	public function __construct() {
	}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
			self::$instance->load(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {
		add_action( 'rest_api_init', array( $this, "hook" ), 99 );
	}

	public function hook() {
		// Divi theme shortcode support
		$this->divi_theme_support();
	}

	/**
	 * Divi Theme Support
	 * - Shortcode not render in course content
	 */
	public function divi_theme_support() {

		if ( is_admin() ){
			return;
		}

		if (defined('ET_CORE_VERSION')) {
			add_filter('the_content', array($this, 'divi_theme_add_builder_shortcodes'), 0);
			add_filter('the_content', array($this, 'divi_theme_remove_builder_shortcodes'), 99999);
		}
	}

	/**
	 * @param $content
	 *
	 * @return mixed
	 */
	public function divi_theme_add_builder_shortcodes($content) {
		if (!class_exists('ET_Builder_Section')) {
			global $wp_query;
			$wp_query->is_singular = true;

			remove_action('wp', 'et_builder_init_global_settings', 9);
			remove_action('wp', 'et_builder_add_main_elements');

			et_builder_init_global_settings();
			et_builder_add_main_elements();
		}
		return $content;
	}

	/**
	 * @param $content
	 *
	 * @return mixed
	 */
	public function divi_theme_remove_builder_shortcodes($content) {
		if (class_exists('ET_Builder_Section')) {
			global $wp_query;
			$wp_query->is_singular = false;
		}
		return $content;
	}
}
