<?php

namespace BuddyBossApp\Integrations\BuddyBossTheme;
// Contains all BuddyBoss Theme related feature
class Main {

	private static $instance;

	/**
	 * Main constructor.
	 */
	public function __construct() {
	}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
			self::$instance->load(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {
		add_action( 'rest_api_init', array( $this, "hook" ) );
	}

	/**
	 *
	 */
	public function hook() {
		if ( function_exists( 'buddyboss_theme' ) ) {
			add_filter( 'bbapp_ld_get_courses', array( $this, 'update_objects_video' ), 20 );
			add_filter( 'bbapp_ld_get_course', array( $this, 'update_object_video' ), 20 );
			add_action( 'rest_api_init', array( $this, "register_custom_fields" ), 99 );
			add_filter( 'bp_rest_groups_prepare_value', array( $this, 'bbapp_group_cover_default' ), 10,3 );
			add_filter( 'bp_rest_members_prepare_value', array( $this, 'bbapp_member_cover_default' ), 10,3 );
		}

		add_filter( 'bbapp_settings_rest_response', array( $this, 'addSettings' ) );
	}

	/**
	 * Get theme settings option.
	 * 
	 * @param $response
	 *
	 * @return mixed
	 */
	public function addSettings( $response ) {
		if ( function_exists( 'buddyboss_theme' ) ) {
			/* Get theme options */
			$response['theme_options'] = get_option( 'buddyboss_theme_options', array() );
		} else {
			$response['theme_options'] = array();
		}

		return $response;
	}

	/**
	 * @param $result
	 *
	 * @return mixed
	 */
	public function update_objects_video( $result ) {
		foreach ( $result['posts'] as $key => $post ) {
			if ( empty( $post->ID ) ) {
				continue;
			}
			if ( ! isset( $post->video ) || empty( $post->video ) ) {
				$course_video_embed             = get_post_meta( $post->ID, '_buddyboss_lms_course_video', true );
				$result['posts'][ $key ]->video = $course_video_embed;
			}
		}

		return $result;
	}

	/**
	 * @param $post
	 *
	 * @return mixed
	 */
	public function update_object_video( $post ) {
		if ( empty( $post->ID ) ) {
			return $post;
		}
		if ( ! isset( $post->video ) || empty( $post->video ) ) {
			$course_video_embed = get_post_meta( $post->ID, '_buddyboss_lms_course_video', true );
			$post->video        = $course_video_embed;
		}

		return $post;
	}

    /**
     * Register course last activity time filed
     */
	public function register_custom_fields(){
        register_rest_field( 'course', 'last_activity_time', array(
                'get_callback' => array( $this, 'get_last_activity_time' ),
                'schema'       => array(
                    'description'       => __( 'Course last activity time.' ),
                    'type'              => 'string',
                    'context'           => array( 'single', 'view', 'edit'),
                )
            )
        );
    }

    /**
     * Set Value of last activity time of course.
     *
     * @param $object
     * @return string
     */
	public function get_last_activity_time( $object ) {
		$last_activity_time = '';
		if ( is_user_logged_in() && function_exists( 'learndash_get_user_activity' ) ) {
			$course_id       = $object['id'];
			$user_id         = get_current_user_id();
			$course_args     = array(
				'course_id'     => $course_id,
				'user_id'       => $user_id,
				'post_id'       => $course_id,
				'activity_type' => 'course',
			);
			$course_activity = learndash_get_user_activity( $course_args );
			if ( $course_activity ) {
				$last_activity      = ! empty ( $course_activity->activity_updated ) ? $course_activity->activity_updated : $course_activity->activity_started;
				$date_time_display  = get_date_from_gmt( date( 'Y-m-d H:i:s', $last_activity ), 'Y-m-d H:i:s' );
				$last_activity_time = mysql_to_rfc3339( $date_time_display ); // phpcs:ignore WordPress.DB.RestrictedFunctions.mysql_to_rfc3339, PHPCompatibility.Extensions.RemovedExtensions.mysql_DeprecatedRemoved
			}
		}

		return $last_activity_time;
	}

	/**
	 * Set default group cover image if cover image not set.
	 *
	 * @param $response
	 * @param $request
	 * @param $item
	 *
	 * @return mixed
	 */
	public function bbapp_group_cover_default( $response, $request, $item ) {
		if ( isset( $response->data ) && empty( $response->data['cover_url'] ) && function_exists( 'buddyboss_theme_get_option' ) ) {
			$response->data['cover_url'] = buddyboss_theme_get_option( 'buddyboss_group_cover_default', 'url' );
		}

		return $response;
	}
	/**
	 * Set default member cover image if cover image not set.
	 *
	 * @param $response
	 * @param $request
	 * @param $item
	 *
	 * @return mixed
	 */
	public function bbapp_member_cover_default( $response, $request, $item ) {
		if ( isset( $response->data ) && empty( $response->data['cover_url'] ) && function_exists( 'buddyboss_theme_get_option' ) ) {
			$response->data['cover_url'] = buddyboss_theme_get_option( 'buddyboss_profile_cover_default','url' );
		}

		return $response;
	}
}
