<?php

namespace BuddyBossApp\Integrations\BuddyBossPlatform;

use BuddyBossApp\UserSegment\SegmentsAbstract as SegmentsAbstract;

class Segment extends SegmentsAbstract {
	/**
	 * BuddyPress constructor.
	 */
	public function __construct() {

		if ( bp_is_active( 'xprofile' ) && true === bp_member_type_enable_disable() ) {

			$this->add_filter( "bb_platform", "user_profile_type", array( "profile_type_select" ) );

			$type_options      = array();
			$member_types = bp_get_active_member_types();
			foreach ( $member_types as $member_type_id ) {
				$type_options[ $member_type_id ] = get_the_title( $member_type_id );
			}
			$this->add_field( "profile_type_select", "Checkbox", array(
				"options"       => $type_options,
				"multiple"      => true,
				"title"         => __( "If the member has any of these profile types", "buddyboss-app" ),
				"empty_message" => __( "No profile type found.", "buddyboss-app" ),
			) );
		}

		if ( bp_is_active( 'groups' ) ) {
			$this->add_filter( "bb_platform", "user_social_group", array( "social_group_select" ) );

			$group_options = array();
			$groups        = groups_get_groups(
				array(
					'orderby'     => 'name',
					'order'       => 'asc',
					'show_hidden' => true,
					'per_page'    => - 1,
				)
			);
			if ( ! empty( $groups['groups'] ) ) {
				foreach ( $groups['groups'] as $group ) {
					$group_options[ $group->id ] = $group->name;
				}
			}
			$this->add_field( "social_group_select", "Checkbox", array(
				"options"       => $group_options,
				"multiple"      => true,
				"title"         => __( "If the member has joined any of these social groups", "buddyboss-app" ),
				"empty_message" => __( "No groups found.", "buddyboss-app" ),
			) );
		}

		$this->load();
	}

	/**
	 * Return Filtered Users.
	 *
	 * @param $r_users_ids
	 *
	 * @return array|mixed
	 */
	function filter_users( $r_users_ids ) {
		$filter    = $this->get_filter_data_value( 'filter' );
		$users_ids = array();

		switch ( $filter ) {
			case 'bb_platform_user_profile_type':
				$users_ids = $this->bp_get_user_by_profile_type();
				break;
			case 'bb_platform_user_social_group':

				$groups_ids = (array) $this->get_filter_data_value( 'social_group_select' );

				foreach ( $groups_ids as $group_id ) {
					if ( ! empty( $group_id ) ) {
						$groups = groups_get_group_members( array(
							'group_id'            => $group_id,
							'per_page'            => 0,
							'exclude_admins_mods' => false,
						) );

						if ( ! empty( $groups['count'] ) ) {
							$_users_ids = wp_list_pluck( $groups['members'], 'ID' );
							$users_ids  = array_merge( $users_ids, $_users_ids );
						}
					}
				}

				$users_ids = array_unique( $users_ids );
				break;
		}

		if ( ! empty( $users_ids ) ) {
			return $users_ids;
		}

		return $r_users_ids;
	}

	private function bp_get_user_by_profile_type() {
		$field_values = (array) $this->get_filter_data_value( "profile_type_select" );

		$users_ids = array();
		foreach ( $field_values as $field_value ) {
			$name       = bp_get_member_type_key( $field_value );
			$type_id    = bp_member_type_term_taxonomy_id( $name );
			$_users_ids = bp_member_type_by_type( $type_id );
			$users_ids  = array_merge( $users_ids, $_users_ids );
		}

		return array_unique( $users_ids );
	}

	function render_script() {
		// TODO: Implement render_script() method.
	}
}
