<?php
/**
 * Holds Members component push notification support.
 *
 * @package BuddyBossApp\Integrations\BuddyBossPlatform\Push
 */

namespace BuddyBossApp\Integrations\BuddyBossPlatform\Push;

use BuddyBossApp\Notification\IntegrationAbstract;

/**
 * Members component push notification support.
 * Class MembersNotification
 *
 * @package BuddyBossApp\Integrations\BuddyBossPlatform\Push
 */
class MembersNotification extends IntegrationAbstract {

	/**
	 * Class instance,.
	 *
	 * @var $instance
	 */
	protected static $instance;

	/**
	 * Load methods.
	 */
	public function load() {
		$this->push_types();
		$this->link_notifications();

	}

	/**
	 * Register Subscriptions Types
	 */
	public function push_types() {
		if ( bbapp_is_platform_notification_preferences_legacy_mode_enabled() ) {
			if ( function_exists( 'bp_is_labs_notification_preferences_support_enabled' ) && bp_is_labs_notification_preferences_support_enabled() ) {
				// Members.
				$this->register_push_group( 'members', __( 'Account Settings', 'buddyboss-app' ) );
				$this->register_push_type( 'bb_account_password', __( 'A member\'s password is updated', 'buddyboss-app' ), __( 'Your password is changed', 'buddyboss-app' ), array( 'push_group' => 'members' ) );
			}
		}
	}

	/**
	 * Link Normal Notification to Push.
	 */
	public function link_notifications() {
		// Members.
		if ( bbapp_is_platform_notification_preferences_legacy_mode_enabled() ) {
			$this->register_push_to_normal( 'members', 'bb_account_password', 'bb_account_password' );
		}
	}

	/**
	 * Function to change push notification format.
	 *
	 * @param string $content           Notification content.
	 * @param string $component_name    Component name.
	 * @param string $component_action  Component action name.
	 * @param int    $item_id           Item id.
	 * @param int    $secondary_item_id Secondary item id.
	 * @param int    $notification_id   Notification id.
	 * @param int    $total_items       Number of total items.
	 * @param string $format            Notification format.
	 * @param string $screen            Screen name.
	 *
	 * @since 1.4.7
	 * @return mixed|string
	 */
	public function format_notification_override( $content, $component_name, $component_action, $item_id, $secondary_item_id, $notification_id, $total_items, $format, $screen ) {
		if ( 'app_push' !== $screen ) {
			return $content;
		}

		switch ( $component_action ) {
			// Modern Notifications.
			case 'bb_account_password':
				// Set up the string and the filter.
				$content['title'] = bp_get_site_name();
				$content['text']  = __( 'Your password was changed. If you didn\'t make this change, please reset your password.', 'buddyboss-app' );
				break;
		}

		return $content;
	}
}
