<?php
/**
 * Holds connected related push notification functionality.
 *
 * @package BuddyBossApp\Integrations\BuddyBossPlatform\Push
 */

namespace BuddyBossApp\Integrations\BuddyBossPlatform\Push;

use BuddyBossApp\Notification\IntegrationAbstract;

/**
 * Friends component push notification support.
 * Class FriendsNotification
 *
 * @package BuddyBossApp\Integrations\BuddyBossPlatform\Push
 */
class FriendsNotification extends IntegrationAbstract {

	/**
	 * Class isntance.
	 *
	 * @var $instance
	 */
	protected static $instance;

	/**
	 * Load methods.
	 */
	public function load() {
		$this->push_types();
		$this->link_notifications();
	}

	/**
	 * Register Subscriptions Types
	 */
	public function push_types() {
		if ( bbapp_is_platform_notification_preferences_legacy_mode_enabled() ) {
			// Friends / Connections.
			$this->register_push_group( 'connections', __( 'Connections', 'buddyboss-app' ) );
			$this->register_push_type( 'bp_friends_friendship_request', __( 'A member receives a new connection request', 'buddyboss-app' ), __( 'A member invites you to connect', 'buddyboss-app' ), array( 'push_group' => 'connections' ) );
			$this->register_push_type( 'bp_friends_friendship_accepted', __( 'A member’s connection request is accepted', 'buddyboss-app' ), __( 'A member accepts your connection request', 'buddyboss-app' ), array( 'push_group' => 'connections' ) );
		}
	}

	/**
	 * Link Normal Notification to Push.
	 */
	public function link_notifications() {
		if ( bbapp_is_platform_notification_preferences_legacy_mode_enabled() ) {
			// Friends.
			$this->register_push_to_normal( 'friends', 'friendship_request', 'bp_friends_friendship_request' );
			$this->register_push_to_normal( 'friends', 'friendship_accepted', 'bp_friends_friendship_accepted' );

			// Modern notification.
			$this->register_push_to_normal( 'friends', 'bb_connections_new_request', 'bp_friends_friendship_request' );
			$this->register_push_to_normal( 'friends', 'bb_connections_request_accepted', 'bp_friends_friendship_accepted' );
		}
	}

	/**
	 * Function to change push notification format.
	 *
	 * @param string $content           Notification content.
	 * @param string $component_name    Component name.
	 * @param string $component_action  Component action name.
	 * @param int    $item_id           Item id.
	 * @param int    $secondary_item_id Secondary item id.
	 * @param int    $notification_id   Notification id.
	 * @param int    $total_items       Number of total items.
	 * @param string $format            Notification format.
	 * @param string $screen            Screen name.
	 *
	 * @since 1.4.7
	 * @return mixed|string
	 */
	public function format_notification_override( $content, $component_name, $component_action, $item_id, $secondary_item_id, $notification_id, $total_items, $format, $screen ) {
		if ( 'app_push' !== $screen ) {
			return $content;
		}

		switch ( $component_action ) {
			// Modern Notifications.
			case 'bb_connections_new_request':
				$content['title'] = bp_core_get_user_displayname( $item_id );
				$content['text']  = esc_html__( 'Sent you a connection request', 'buddyboss-app' );
				break;
			case 'bb_connections_request_accepted':
				$content['title'] = bp_core_get_user_displayname( $item_id );
				$content['text']  = esc_html__( 'Has accepted your connection request', 'buddyboss-app' );
				break;
			// Legacy Notifications.
			case 'friendship_request':
			case 'friends-request-accepted':
				break;
		}

		return $content;
	}
}
