<?php

namespace BuddyBossApp\Integrations\BuddyBossPlatform;

use BuddyBossApp\Integrations\BuddyBossPlatform\Push\ActivityNotification;
use BuddyBossApp\Integrations\BuddyBossPlatform\Push\ForumsNotification;
use BuddyBossApp\Integrations\BuddyBossPlatform\Push\FriendsNotification;
use BuddyBossApp\Integrations\BuddyBossPlatform\Push\GroupsNotification;
use BuddyBossApp\Integrations\BuddyBossPlatform\Push\MembersNotification;
use BuddyBossApp\Integrations\BuddyBossPlatform\Push\MessagesNotification;

/**
 * Integration code related to BuddyBoss Platform.
 * Class Main
 *
 * @package BuddyBossApp\Integrations\BuddyBossPlatform
 */
class Main {

	private static $instance;

	/**
	 * Activity user
	 * @var array
	 */
	public $user_ids = array();

	/**
	 * Main constructor.
	 */
	public function __construct() {
	}

	/**
	 * @return Main
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
			self::$instance->hooks(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 * Adding Hooks
	 */
	public function hooks() {
		add_action( "bp_init", array( $this, "load" ) );
		add_filter( "rest_api_init", array( $this, "register_header" ), 20 );
		add_filter( 'bp_rest_activity_prepare_links', array( $this, 'bbapp_rest_activity_prepare_links' ), 10, 2 );
		add_action( 'wp_head', array( $this, 'bbapp_head_style' ) );

		if ( wp_is_mobile() ) {
			// Remove Admin bar.
			add_filter( 'show_admin_bar', '__return_false' );
			add_filter( 'bp_hide_loggedout_adminbar', '__return_true' );
			add_filter( 'bp_show_login_adminbar', '__return_false' );
			add_filter( 'bp_show_admin_adminbar', '__return_false' );
		}
	}

	/**
	 * User Unread message count update on cache header.
	 *
	 * @return mixed
	 */
	public function register_header() {
		if ( is_user_logged_in() && ! is_admin() ) {

			$count = (int) $this->bbapp_messages_get_unread_count( get_current_user_id() );
			header( "bbp-unread-messages:" . $count );
		}
	}

	/**
	 * Get message unread count for user.
	 *
	 * @param $user_id
	 *
	 * @return int|mixed
	 */
	private function bbapp_messages_get_unread_count( $user_id ) {

		global $wpdb;
		$table_name = $wpdb->prefix . 'bp_messages_recipients';
		// phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		if ( $wpdb->get_results( "SHOW TABLES LIKE '{$table_name}'" ) ) {
			$get = $wpdb->get_col( $wpdb->prepare( "SELECT SUM(DISTINCT r.unread_count) FROM {$table_name} r WHERE r.user_id = %s AND r.is_deleted = 0 ORDER BY r.id DESC", $user_id ) );

			return isset( $get[0] ) ? $get[0] : 0;
		}

		return 0;
	}

	/**
	 * Load all required classes.
	 *
	 * @return void
	 */
	public function load() {

		Rest::instance();

		if ( function_exists( 'bp_is_active' ) ) {
			// Activity
			if ( bp_is_active( 'activity' ) ) {

				ActivityNotification::instance();
			}
			// Groups
			if ( bp_is_active( 'groups' ) ) {
				GroupsNotification::instance();

			}
			// Friends / Connections.
			if ( bp_is_active( 'friends' ) ) {
				FriendsNotification::instance();
			}
			// Messages
			if ( bp_is_active( 'messages' ) ) {
				MessagesNotification::instance();
			}
			// Members
			if ( bp_is_active( 'members' ) ) {
				MembersNotification::instance();
			}
		}
		// Forum
		if ( function_exists( 'bbpress' ) ) {
			ForumsNotification::instance();
		}

		if ( $this->is_buddyboss_platform_loaded() ) {
			add_filter( 'bbapp_user_segment_integrations', array( $this, 'load_segment' ) );
		}
	}

	/**
	 * Load BuddyPress Platform related user segments
	 *
	 * @param $integrations
	 *
	 * @return mixed
	 */
	public function load_segment( $integrations ) {
		$integrations['buddyboss_platform'] = new Segment();

		return $integrations;
	}

	/**
	 * Tells if only BuddyPress is loaded.
	 *
	 * @return bool
	 */
	public function is_buddypress_loaded() {
		return (
			function_exists( 'buddypress' ) &&
			! isset( buddypress()->buddyboss )
		);
	}

	/**
	 * Tells if buddyboss platform is loaded or not.
	 *
	 * @return bool
	 */
	public function is_buddyboss_platform_loaded() {
		return (
			function_exists( 'buddypress' ) &&
			isset( buddypress()->buddyboss ) &&
			buddypress()->buddyboss
		);
	}

	/**
	 * Activity item user prepare links.
	 *
	 * @param $links
	 * @param $activity
	 *
	 * @return mixed
	 */
	public function bbapp_rest_activity_prepare_links( $links, $activity ) {
		if ( ! in_array( $activity->user_id, $this->user_ids ) ) {
			$this->user_ids[] = $activity->user_id;
		}
		if ( ! empty( $this->user_ids ) ) {
			$user_rest = array();
			foreach ( $this->user_ids as $user_id ) {
				$user_rest[] = array(
					'href'       => rest_url( bp_rest_get_user_url( $user_id ) ),
					'embeddable' => true,
				);
			}
			$links['user'] = $user_rest;
		}

		return $links;
	}

	/***
	 * Group show sub tab.
	 */
	public function bbapp_head_style(){
		?>
		<style>
            body.groups.in-bbapp .item-body nav#object-nav {
                display: block;
            }
        </style>
		<?php
	}
}
