<?php
/**
 * Holds Access Controls functioanlity related to BuddyBoss Platform.
 *
 * @package BuddyBossApp\Integrations\BuddyBossPlatform
 */

namespace BuddyBossApp\Integrations\BuddyBossPlatform;

use BuddyBossApp\Integrations\BuddyBossPlatform\AccessControls\ProfileType;
use BuddyBossApp\Integrations\BuddyBossPlatform\AccessControls\SocialGroup;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * Access Controls class for BuddyBoss Platform.
 */
class AccessControls extends \BuddyBossApp\AccessControls\Integration_Abstract {

	/**
	 * Function to set up the conditions.
	 *
	 * @since 1.5.2.1
	 *
	 * @return mixed|void
	 */
	public function setup() {

		// Register Conditions.
		$this->register_conditions();

		// Register Instance.
		$this->load_hooks();
	}

	/**
	 * Function to register conditions.
	 *
	 * @since 1.5.2.1
	 */
	public function register_conditions() {
		if ( function_exists( 'bp_member_type_enable_disable' ) && bp_member_type_enable_disable() ) {
			$this->register_condition(
				array(
					'condition'         => ProfileType::instance()->condition_name,
					'items_callback'    => array( ProfileType::instance(), 'profile_type_items_callback' ),
					'item_callback'     => array( ProfileType::instance(), 'profile_type_item_callback' ),
					'users_callback'    => array( ProfileType::instance(), 'profile_type_users_callback' ),
					'labels'            => array(
						'condition_name' => __( 'Profile Type', 'buddyboss-app' ),
						'item_singular'  => __( 'Type', 'buddyboss-app' ),
					),
					'support_any_items' => false,
				)
			);
		}

		if ( function_exists( 'bp_is_active' ) && bp_is_active( 'groups' ) ) {
			$this->register_condition(
				array(
					'condition'              => SocialGroup::instance()->condition_name,
					'items_callback'         => array( SocialGroup::instance(), 'social_group_items_callback' ),
					'item_callback'          => array( SocialGroup::instance(), 'social_group_item_callback' ),
					'users_callback'         => array( SocialGroup::instance(), 'social_group_users_callback' ),
					'labels'                 => array(
						'condition_name'          => __( 'Social Groups', 'buddyboss-app' ),
						'item_singular'           => __( 'Group', 'buddyboss-app' ),
						'member_of_specific_item' => __( 'Member of specific group', 'buddyboss-app' ),
						'member_of_any_items'     => __( 'Member of any group', 'buddyboss-app' ),
					),
					'support_any_items'      => true,
					'has_any_items_callback' => array( SocialGroup::instance(), 'has_any_items_callback' ),
				)
			);
		}
	}

	/**
	 * Function to load all hooks of this condition.
	 *
	 * @since 1.5.2.1
	 */
	public function load_hooks() {
		// *******************************************************************//
		// *********************** Profile types hooks ***********************//
		// *******************************************************************//
		add_action( 'add_user_role', array( ProfileType::instance(), 'bbapp_add_user_role' ), 10, 2 );
		add_action( 'remove_user_role', array( ProfileType::instance(), 'bbapp_remove_user_role' ), 10, 2 );
		add_action( 'bp_set_member_type', array( ProfileType::instance(), 'bbapp_set_member_type' ), 10, 3 );
		add_action( 'bp_remove_member_type', array( ProfileType::instance(), 'bbapp_remove_member_type' ), 10, 2 );
		add_action( 'xprofile_updated_profile', array( ProfileType::instance(), 'bbapp_xprofile_updated_profile' ), 10, 5 );
		add_action( 'delete_term_relationships', array( ProfileType::instance(), 'bbapp_delete_term_relationships' ), 10, 3 );
		add_action( 'transition_post_status', array( ProfileType::instance(), 'bbapp_trashed_post' ), 10, 3 );
		add_action( 'untrashed_post', array( ProfileType::instance(), 'bbapp_untrashed_post' ), 10, 2 );

		// *******************************************************************//
		// *********************** Social groups hooks ***********************//
		// *******************************************************************//
		add_action( 'groups_join_group', array( SocialGroup::instance(), 'bbapp_groups_join_group' ), 10, 2 );
		add_action( 'groups_unban_member', array( SocialGroup::instance(), 'bbapp_groups_unban_member' ), 10, 2 );
		add_action( 'groups_promote_member', array( SocialGroup::instance(), 'bbapp_groups_promote_member' ), 10, 3 );
		add_action(
			'bp_invitations_accepted_request',
			array(
				SocialGroup::instance(),
				'bbapp_invitations_accepted_request',
			),
			10,
			1
		);
		add_action( 'groups_ban_member', array( SocialGroup::instance(), 'bbapp_groups_ban_member' ), 10, 2 );
		add_action( 'groups_leave_group', array( SocialGroup::instance(), 'bbapp_groups_leave_group' ), 10, 2 );
		add_action( 'bp_groups_delete_group', array( SocialGroup::instance(), 'bbapp_groups_delete_group' ), 10, 2 );
		add_action(
			'bp_groups_member_after_delete',
			array(
				SocialGroup::instance(),
				'bbapp_groups_member_after_delete',
			),
			10,
			2
		);
		add_action( 'groups_reject_invite', array( SocialGroup::instance(), 'bbapp_groups_reject_invite' ), 10, 3 );
		add_action( 'groups_delete_invite', array( SocialGroup::instance(), 'bbapp_groups_delete_invite' ), 10, 3 );
		add_action(
			'groups_member_after_remove',
			array(
				SocialGroup::instance(),
				'bbapp_groups_member_after_remove',
			),
			10,
			1
		);
		add_action(
			'groups_membership_rejected',
			array(
				SocialGroup::instance(),
				'bbapp_groups_membership_rejected',
			),
			10,
			3
		);
		add_action(
			'bp_invitations_accepted_invite',
			array(
				SocialGroup::instance(),
				'bbapp_invitations_accepted_invite',
			),
			10,
			1
		);
		add_action(
			'groups_delete_group',
			array(
				SocialGroup::instance(),
				'bbapp_groups_delete_group_members',
			),
			10,
			1
		);
	}
}
