<?php
namespace BuddyBossApp\Integrations\BbpPrivateGroups;

// All BbpPrivateGroups related chages
class Main {

	private static $instance;

	/**
	 * Main constructor.
	 */
	public function __construct() {}

	/**
	 * @return mixed
	 */
	public static function instance() {
		if (!isset(self::$instance)) {
			$class = __CLASS__;
			self::$instance = new $class;
			self::$instance->load(); // run the hooks.
		}
		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {
		add_action( 'init', array( $this, 'init') );
	}

	/**
	 *
	 */
	public function init(){
		if( defined('PG_PLUGIN_DIR') ) {
			add_action( 'boss_rest_forum_query', array( $this, 'filterForums' ) );
			add_filter( "bbp_exclude_forum_ids", array( $this, "excludeForumsIds" ), 9999, 3 );

			add_filter( "rest_prepare_forum", array( $this, "updateForumPermission" ), 999, 2 );
			add_filter( "rest_prepare_topic", array( $this, "updateTopicPermission" ), 999, 2 );
			add_filter( "rest_prepare_reply", array( $this, "updateReplyPermission" ), 999, 2 );
		}
	}

	/**
	 * @param $args
	 *
	 * @return mixed
	 */
	public function filterForums( $args ){
		global $rpg_settingsf ;
		
		if (empty($rpg_settingsf['set_forum_visibility'])) {
			global $wpdb;
			$forum=bbp_get_forum_post_type() ;
			$forum_ids=$wpdb->get_col("select ID from $wpdb->posts where post_type = '$forum'") ;
			$allowed_posts = private_groups_check_permitted_forums($forum_ids) ;
			if (empty ($allowed_posts))  $allowed_posts[] = -1 ;
			if ( ! empty( $args['post__in'] ) ){
				$allowed_posts = array_intersect( $args['post__in'], $allowed_posts );
			}
			$args['post__in'] = $allowed_posts;
		}

		return $args;
	}

	/**
	 * @param $retval
	 * @param $forum_ids
	 * @param $type
	 *
	 * @return array|string
	 */
	public function excludeForumsIds( $retval, $forum_ids, $type ){

		global $rpg_settingsf ;

		if (empty($rpg_settingsf['set_forum_visibility'])) {
			global $wpdb;
			$forum=bbp_get_forum_post_type() ;
			$forums=$wpdb->get_col("select ID from $wpdb->posts where post_type = '$forum'") ;
			$allowed_posts = private_groups_check_permitted_forums($forums) ;
			if (empty ($allowed_posts))  $allowed_posts[] = -1 ;
			$Not_allowed_posts = array_diff( $forums, $allowed_posts );

			$forum_ids = array_merge( $forum_ids, $Not_allowed_posts );
			$forum_ids = array_unique( $forum_ids );

			if ( ! empty( $forum_ids ) ){
				switch ($type) {
					case 'string':
						$retval = implode(',', $forum_ids);
						break;

					// Use forum_ids array
					case 'array':
						$retval = $forum_ids;
						break;

					// Build a meta_query
					case 'meta_query':
						$retval = array(
							'key' => '_bbp_forum_id',
							'value' => implode(',', $forum_ids),
							'type' => 'numeric',
							'compare' => (1 < count($forum_ids)) ? 'NOT IN' : '!=',
						);
						break;
				}
			}

		}
		return $retval;
	}

	/**
	 * @param $response
	 * @param $post
	 *
	 * @return mixed
	 */
	public function  updateForumPermission( $response, $post ){
		global $rpg_topic_permissions ;
		if ( !empty ($rpg_topic_permissions['activate']) ) {
			$valuecheck = pg_check_topic_permissions( $post->ID );
			if ( ! empty( $valuecheck ) ) {
				if ( $response->data['current_user_permissions']['topic'] ) {
					$response->data['current_user_permissions']['topic'] = false;
					if ( isset( $valuecheck['check5'] ) || isset( $valuecheck['check4'] ) || isset( $valuecheck['check2'] ) ) {
						$response->data['current_user_permissions']['topic'] = true;
					}
				}
			}
		}
		return $response;
	}

	/**
	 * @param $response
	 * @param $post
	 *
	 * @return mixed
	 */
	public function  updateTopicPermission( $response, $post ){
		global $rpg_topic_permissions ;
		if ( !empty ($rpg_topic_permissions['activate']) ) {
			$valuecheck = pg_check_topic_permissions( $post->post_parent );
			if ( ! empty( $valuecheck ) ) {
				if ( $response->data['current_user_permissions']['reply'] ) {
					$response->data['current_user_permissions']['reply'] = false;
					if ( isset( $valuecheck['check5'] ) || isset( $valuecheck['check4'] ) || isset( $valuecheck['check3'] ) ) {
						$response->data['current_user_permissions']['reply'] = true;
					}
				}

				if ( $response->data['current_user_permissions']['edit'] ) {
					$response->data['current_user_permissions']['edit'] = false;
					if ( isset( $valuecheck['check5'] ) || isset( $valuecheck['check4'] ) || isset( $valuecheck['check2'] ) ) {
						$response->data['current_user_permissions']['edit'] = true;
					}
				}
			}
		}
		return $response;
	}

	/**
	 * @param $response
	 * @param $post
	 *
	 * @return mixed
	 */
	public function  updateReplyPermission( $response, $post ){
		global $rpg_topic_permissions ;
		$form_id = get_post_meta($post->ID, '_bbp_forum_id', true);
		if ( !empty ($rpg_topic_permissions['activate']) ) {
			$valuecheck = pg_check_topic_permissions( $form_id );
			if ( ! empty( $valuecheck ) ) {
				if ( $response->data['current_user_permissions']['edit'] ) {
					$response->data['current_user_permissions']['edit'] = false;
					if ( isset( $valuecheck['check5'] ) || isset( $valuecheck['check4'] ) || isset( $valuecheck['check3'] ) ) {
						$response->data['current_user_permissions']['edit'] = true;
					}
				}
			}
		}
		return $response;
	}

}