<?php

namespace BuddyBossApp\Integrations\BadgeOs;

use BuddyBossApp\App\App;

class RestAPI
{

    protected static $instance;

	/**
	 * RestAPI constructor.
	 */
    public function __construct()
    {
        /** Nothing here */
    }

	/**
	 * @return mixed
	 */
    public static function instance()
    {
        if (!isset(self::$instance)) {
            $class = __CLASS__;
            self::$instance = new $class;
            self::$instance->hooks(); // run the hooks.
        }
        return self::$instance;
    }

	/**
	 *
	 */
    public function hooks()
    {
        add_action('init', array($this, 'init'));
        add_filter('bbapp_profile_tab', array($this, 'updateAppProfileTab'), 10, 2);
        add_filter('bp_rest_profile_tab', array($this, 'updateAppProfileTab'), 10, 2);
    }

	/**
	 *
	 */
    public function init()
    {
        if (class_exists('BadgeOS')) {

            add_filter( 'bbapp_settings_rest_response', array( $this, 'addSettings' ) );

            App::instance()->add_local_feature("badgeos", array(
                "is_enabled_android" => true,
                "is_enabled_ios" => true,
            ));

            RestAPIPoint::instance();
            RestAPIAchievement::instance();
            RestAPIRank::instance();
        }
    }

	/**
	 * @param $response
	 *
	 * @return mixed
	 */
    public function addSettings( $response ){
        /**
         * In badgesOS Not provided this setting so we hardcoded defaults
         * Placement
         * "":     Means not to display
         * 'Top':  Means display on profile header
         * 'Tab':  Means display in profile tabs
         * 'both': Means Display on Profile header as well as in Profile tab.
         */

        $response["badges"] = array(
            'points_placement' => 'both',
            'ranks_placement' => 'Tab',
            'achievements_placement' => 'both'
        );
        return $response;
    }

	/**
	 * @param $tab
	 * @param $nav
	 *
	 * @return mixed
	 */
    public function updateAppProfileTab($tab, $nav)
    {
        if (!class_exists('BadgeOS')) {
            return $tab;
        }

        if (in_array($nav->screen_function, array('badgeos_bp_member_points', 'badgeos_bp_member_achievements', 'badgeos_bp_member_ranks'))) {
	        $tab['id'] = 'badgeos_' . strtolower( $tab['id'] );
        }

        return $tab;
    }

	/**
	 *
	 * Ref_Files: badgeos/includes/achievement-functions.php:577
	 * Ref_Funcation: badgeos_get_achievement_post_thumbnail
	 *
	 * @param int    $post_id
	 * @param string $image_size
	 * @param bool   $default
	 *
	 * @return mixed
	 */
    public static function badgeos_get_achievement_post_thumbnail_url($post_id = 0, $image_size = 'gamipress-achievement', $default = true)
    {

        // Get our badge thumbnail
        $image_url = get_the_post_thumbnail_url($post_id, $image_size);
        // If we don't have an image...
        if (!$image_url && $default) {

            // Grab our achievement type's post thumbnail
            $achievement = get_page_by_path(get_post_type($post_id), OBJECT, 'achievement-type');
            $image = is_object($achievement) ? get_the_post_thumbnail_url($achievement->ID, $image_size) : false;

            // If we still have no image, use one from Credly
            if (!$image) {
                // Available filter: 'badgeos_default_achievement_post_thumbnail'
                $image_url = apply_filters('badgeos_default_achievement_post_thumbnail', 'https://credlyapp.s3.amazonaws.com/badges/af2e834c1e23ab30f1d672579d61c25a_15.png');

            }
        }

        // Finally, return our image tag
        return $image_url;
    }
}