<?php

namespace BuddyBossApp\Integrations\BadgeOs;

// Contains all bbpress related feature
class Main {

	private static $instance;

	/**
	 *
	 */
	public function __construct() {
	}

	/**
	 *
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class;
			self::$instance->load(); // run the hooks.
		}

		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {
		RestAPI::instance();
		add_filter( 'bbapp_app_menu', array( $this, 'tabbar_menus' ) );
		add_filter( 'bbapp_get_menu_icon', array( $this, 'menu_icon' ), 10, 2 );
		add_filter( 'filter_app_menu_by_dependency', array( $this, 'filter_app_menu_by_dependency' ), 10, 2 );
	}

	/**
	 * Register Tabbar Menu's
	 */
	public function tabbar_menus( $app_menu ) {

		if ( class_exists( 'BadgeOS' ) ) {

			$app_menu[] = array(
				"id"       => uniqid(),
				"object"   => "badgeos_achievements",
				"label"    => __( "BadgeOS Achievements", 'buddyboss-app' ),
				"original" => __( "BadgeOS Achievements", 'buddyboss-app' ),
				"type"     => "core",
				'data'     => array(
					'id'     => 'badgeos_achievements',
					'parent' => 'badgeos_achievements',
				),
				"icon"     => array(
					'id'   => 'gem',
					'type' => 'buddyboss',
				),
			);

		}

		return $app_menu;
	}

	/**
	 * Update default achievement menu icon.
	 *
	 * @param $iconDefaults
	 * @param $item_name
	 *
	 * @return mixed|string[]
	 */
	public function menu_icon( $iconDefaults, $item_name ) {
		if ( 'badgeos_achievements' == $item_name ) {
			$iconDefaults =array(
				'id'   => 'gem',
				'type' => 'buddyboss',
			);
		}

		return $iconDefaults;
	}
	/**
	 * Menu dependency added.
	 *
	 * @param $status
	 * @param $menu
	 *
	 * @return false
	 */
	public function filter_app_menu_by_dependency( $status, $menu ) {
		if ( 'badgeos_achievements' === $menu['object'] ) {
			return class_exists( 'BadgeOS' );
		}

		return $status;
	}
}