<?php
namespace BuddyBossApp\Integrations\AdvancedRecaptcha;

// All Advanced Nocaptcha Recaptcha related changes
class Main {

	private static $instance;

	/**
	 *
	 */
	public function __construct() {}

	/**
	 *
	 */
	public static function instance() {
		if (!isset(self::$instance)) {
			$class = __CLASS__;
			self::$instance = new $class;
			self::$instance->load(); // run the hooks.
		}
		return self::$instance;
	}

	/**
	 *
	 */
	public function load() {
        if ( class_exists( 'anr_captcha_class' ) ) {
            add_action('rest_api_init', array($this, 'removeHook'), 10);
        }
	}

	/**
	 *
	 */
    public function removeHook(){

        if ( anr_is_form_enabled( 'lost_password' ) ) {
            remove_action( 'lostpassword_post', array( anr_captcha_class::init(), 'lostpassword_verify_44' ) );
        }

        if ( anr_is_form_enabled( 'bbp_new' ) ) {
            remove_action( 'bbp_new_topic_pre_extras', array( anr_captcha_class::init(), 'bbp_new_verify' ) );
        }

        if ( anr_is_form_enabled( 'bbp_reply' ) ) {
            remove_action( 'bbp_new_reply_pre_extras', array( anr_captcha_class::init(), 'bbp_reply_verify' ), 10, 2 );
        }

        if ( anr_is_form_enabled( 'comment' ) ) {
            remove_action( 'preprocess_comment', array( anr_captcha_class::init(), 'comment_verify' ) );
        }
    }
}