<?php
/**
 * Holds Tutor LMS related functionality for IAP.
 *
 * @package BuddyBossApp\InAppPurchases
 */

namespace BuddyBossApp\InAppPurchases;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

/**
 * Tutor LMS rest class.
 */
final class TutorLmsIapRest {
	/**
	 * Class instance.
	 *
	 * @var null $instance
	 */
	private static $instance;

	/**
	 * LearnDashIapRest rest constructor.
	 */
	private function __construct() {
		// ... leave empty, see Singleton below
	}

	/**
	 * CoursesRest instance.
	 *
	 * @since 2.2.80
	 * @return TutorLmsIapRest
	 */
	public static function instance() {
		if ( null === self::$instance ) {
			$class_name     = __CLASS__;
			self::$instance = new $class_name();
			self::$instance->hooks();
		}

		return self::$instance;
	}

	/**
	 * Define all actions and filters here
	 *
	 * @since 2.2.80
	 */
	public function hooks() {
		add_filter( 'bbapp_tutor_rest_prepare_course', array( $this, 'rest_integrate_iap_product' ), 20 );
	}

	/**
	 * Verify need of InAppPurchase(bbapp_products) details in course-response.
	 *
	 * @param object $response Response object.
	 *
	 * @since 2.2.80
	 * @return mixed
	 */
	public function rest_integrate_iap_product( $response ) {
		$iap_product_href = rest_url( 'buddyboss-app/iap/v1/products/integration/' . $response->data['id'] );
		$response->add_link(
			'iap_products',
			$iap_product_href,
			array(
				'href'       => $iap_product_href,
				'embeddable' => true,
			)
		);

		return $response;
	}
}
