<?php
/**
 * InAppPurchases Subscription taxonomy.
 *
 * @package BuddyBossApp\InAppPurchases
 */

namespace BuddyBossApp\InAppPurchases;

/**
 * Class SubscriptionGroupTaxonomy
 *
 * @package BuddyBossApp\InAppPurchases
 */
class SubscriptionGroupTaxonomy {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	public static $instance;

	/**
	 * Taxonomy slug.
	 *
	 * @var string $taxonomy
	 */
	public static $taxonomy = 'app-subscription-group';

	/**
	 * Get the instance of the class.
	 *
	 * @return SubscriptionGroupTaxonomy
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load();
		}

		return self::$instance;
	}

	/**
	 * Load the all hooks.
	 */
	public function load() {
		$this->hooks();
	}

	/**
	 * Define all Hooks.
	 */
	public function hooks() {
		add_action( 'init', array( $this, 'register_taxonomy' ) );
	}

	/**
	 * Register IAP Group Taxonomy.
	 */
	public function register_taxonomy() {
		register_taxonomy(
			self::$taxonomy,
			null,
			array(
				'labels'            => array(
					'name'              => _x( 'Subscription Groups', 'taxonomy general name', 'buddyboss-app' ),
					'singular_name'     => _x( 'Subscription Group', 'taxonomy singular name', 'buddyboss-app' ),
					'search_items'      => __( 'Search Groups', 'buddyboss-app' ),
					'all_items'         => __( 'All Subscription Groups', 'buddyboss-app' ),
					'parent_item'       => __( 'Parent Subscription Group', 'buddyboss-app' ),
					'parent_item_colon' => __( 'Parent Subscription Group:', 'buddyboss-app' ),
					'edit_item'         => __( 'Edit Subscription Group', 'buddyboss-app' ),
					'update_item'       => __( 'Update Subscription Group', 'buddyboss-app' ),
					'add_new_item'      => __( 'Add New Subscription Group', 'buddyboss-app' ),
					'new_item_name'     => __( 'New Subscription Group Name', 'buddyboss-app' ),
					'menu_name'         => __( 'Subscription Group', 'buddyboss-app' ),
					'not_found'         => __( 'No subscription groups found.', 'buddyboss-app' ),
				),
				'public'            => true,
				'show_admin_column' => true,
			)
		);
	}

	/**
	 * Get group name by id.
	 *
	 * @param int $group_id Subscription group id.
	 *
	 * @return string
	 */
	public static function get_group_name( $group_id ) {

		if ( ! empty( $group_id ) ) {

			$group_term = get_term_by( 'id', $group_id, self::$taxonomy );
			if ( is_wp_error( $group_term ) && $group_term->get_error_message() ) {
				return '';
			}

			return $group_term->name;
		}

		return '';
	}
}
